package cn.com.duiba.duiba.qutui.center.api.enums;

import java.util.Objects;

/**
 * 微信各种账号的业务类型。
 * 如需请求带有access_token 参数的接口，请在{@link  cn.com.duiba.kjy.service.accesstoken.RequestTokenHandle}实现中做相对应的处理
 * Created by dugq on 2019-06-01.
 */
public enum OATypeEnum {
    OPEN_PL(1,null,"第三方服务平台"),

    OPEN_MP(2,OaTargetEnum.MP.getCode(),"第三方服务平台服务的小程序"),

    ;
    private final Integer type;
    //1:公众号 2：小程序 3:web应用
    private final Integer target;
    private final  String desc;

    OATypeEnum(Integer type, Integer target, String desc) {
        this.type = type;
        this.target = target;
        this.desc = desc;
    }

    public Integer getTarget() {
        return target;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static OATypeEnum typeOf(Integer type) {
        for (OATypeEnum e :values())
            if (Objects.equals(type, e.getType())) {
                return e;
            }
        throw new UnsupportedOperationException("不支持的oa类型");
    }

}
