package cn.com.duiba.duiba.qutui.center.api.remoteservice.mpAuth.openpl;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.qutui.center.api.dto.auth.mpDetail.ComponentMpDetailInfoDto;

/**
 * @author dugq
 * @date 2020/11/24 11:50 下午
 */
@AdvancedFeignClient
public interface RemoteComponentMpInfoService {
    /**
     * 1、在授权成功后，根据authCode获取授权公众号的AuthInfo
     * 2、根据authInfo的appId获取oa accountInfo
     * 3、保存授权公众号到数据库
     * @param authCode 授权码
     * @return 0：失败 1：成功
     */
    int saveAuthedOaInfo(String authCode);

    /**
     * 取消授权
     * @param appId 取消授权的appId
     * @return 0：失败 1：成功
     */
    int cancelAuthedOaInfo(String appId);

    /**
     * 第三方服务平台测试用例
     * 微信要求必须有。
     */
    void openPlTestCase(String authCode, String openId);


    /**
     * 根据授权公众号的appID获取账号信息
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/Mini_Program_Information_Settings.html">文档详情</a>
     * @param appId 公众号ID
     * @return 账号信息
     */
    ComponentMpDetailInfoDto getMpBaseInfoByAppId(String appId);
}
