package cn.com.duiba.duiba.qutui.center.api.remoteservice.visit;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.qutui.center.api.dto.visit.UsersVisitDto;
import cn.com.duiba.duiba.qutui.center.api.param.usersvisit.ClueListParam;

import java.util.Date;
import java.util.List;

/**
* 用户访问记录表 RemoteService
* @author xiaotian
* 2021-3-17 21:31:24
*/
@AdvancedFeignClient
public interface RemoteUsersVisitService {
    /**
    * 新增记录
    */
	Boolean save(UsersVisitDto dto);

    /**
    * 根据id删除
    */
    Boolean deleteById(Long id);
    /**
    * 根据id更新
    */
    Boolean updateById(UsersVisitDto dto);
    /**
    * 根据id获取
    */
    UsersVisitDto getById(Long id);

    /**
     * 筛选线索列表
     * @param clueListParam
     * @return
     */
    List<UsersVisitDto> queryList(ClueListParam clueListParam);

    /**
     * 筛选数量
     * @param clueListParam
     * @return
     */
    Integer queryListCount(ClueListParam clueListParam);

    /**
     * 获取统计数据
     * @param staffId
     * @param start
     * @param end
     * @return
     */
    Integer queryTotalCountByTime(Long staffId, Date start, Date end);


}
