package cn.com.duiba.duiba.qutui.center.api.dto.task;

import lombok.Data;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;

/**
 * @author xiaotian
 * @version 1.0.0
 * @ClassName EventTypeDto.java
 * @Description
 * @createTime 2021年05月10日 20:20:00
 */
@Data
public class EventTypeDto implements Serializable {

    /**
     * 普通类型
     */
    public static final Integer COMMON = 1;

    /**
     * 关注公众号事件
     */
    public static final Integer SUBSCRIBE = 2;

    /**
     * 完成方式
     */
    private Integer eventType;

    /**
     * 关注自动回复
     */
    private String replyContent;

    /**
     * 关注跳转的活动链接
     */
    private String jumpUrl;

    public String check() {
        if (eventType == null) {
            return "请选择事件类型";
        }

        if (StringUtils.isBlank(jumpUrl)) {
            return "请填写跳转活动连接";
        }

        if (jumpUrl.length()>400) {
            return "活动连接请小于400字";
        }

        if(replyContent.length()>600){
            return "关注后回复文案请小于600字";
        }
        return null;
    }


    public static EventTypeDto commonDto(){
        EventTypeDto eventTypeDto = new EventTypeDto();
        eventTypeDto.setEventType(COMMON);
        eventTypeDto.setJumpUrl("");
        eventTypeDto.setReplyContent("");
        return eventTypeDto;
    }


}
