package cn.com.duiba.duiba.qutui.center.api.enums;


import java.util.HashMap;
import java.util.Map;

/**
 * Created by xiaotian on 2021/03/16.
 */
public enum CustomerQueryTypeEnum {

    /**
     * 默认按首字母排
     */
    ALL(1, "全部"),

    /**
     * 按最近来访时间排序
     */
    LAST_VISIT(2, "最近来访"),
    ;

    private Integer code;
    private String desc;

    CustomerQueryTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, CustomerQueryTypeEnum> ENUM_MAP = new HashMap<>();

    static {
        for (CustomerQueryTypeEnum type : values()) {
            ENUM_MAP.put(type.getCode(), type);
        }
    }

    public static CustomerQueryTypeEnum getByCode(String code) {
        CustomerQueryTypeEnum result = ENUM_MAP.get(code);
        if (result == null) {
            return null;
        }
        return result;
    }
}
