package cn.com.duiba.duiba.qutui.center.api.enums;


/**
 * Created by xiaotian on 2019-02-21.
 */
public enum ErrorCode {
    //通用
    DATE_ERROR("990001","数据错误"),
    SYSTEM("999999","系统错误"),

    //01 微信统一接口
    WECHAT_OA_TOKEN_ERROR("010001","token错误"),
    NOT_SUPPORT_MESSAGE("010002","不支持的消息"),
    REQUEST_FAIL("010003","请求失败"),

    //02 微信消息推送
    PARAM_ERROR("020001","参数错误"),
    FUNCTION_DOWN("020002","功能已下线"),

    //03 二维码绑定失败
    BIND_MP_QRCODE_ERROR("030001","绑定小程序二维码失败"),
    MP_QRCODE_CONFIG_ERROR("030002", "小程序码配置异常"),
    ;

    private String shortCode;
    private String desc;

    ErrorCode(String shortCode, String desc) {
        this.shortCode = shortCode;
        this.desc = desc;
    }
    public String getCode(){
        return getHost()+ getShortCode();
    }

    public String getHost() {
        return "04";//NOSONAR
    }

    public String getShortCode() {
        return shortCode;
    }

    public String getDesc() {
        return desc;
    }
}
