package cn.com.duiba.duiba.qutui.center.api.enums;

/**
 * @author linzhou
 * @version 1.0.0
 * @ClassName GradeTimeEnum.java
 * @Description 排行榜时间类型
 * @createTime 2021年04月19日 10:26:00
 */
public enum GradeTimeRangeEnum {

    YESTERDAY(1, "昨日"),
    WEEK(2, "本周"),
    MONTH(3, "本月");
    private int code;
    private String desc;

    GradeTimeRangeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static GradeTimeRangeEnum getEnum(int code) {
        for (GradeTimeRangeEnum value : GradeTimeRangeEnum.values()) {
            if (value.getCode() == code) {
                return value;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
