package cn.com.duiba.duiba.qutui.center.api.remoteservice.mpAccounts;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.qutui.center.api.dto.mpAccounts.MpAccountsDto;
import cn.com.duiba.duiba.qutui.center.api.param.mpAccount.QueryPageParam;

import java.util.List;

/**
* 小程序表 RemoteService
* @author xiaotian
* 2021-3-18 16:07:58
*/
@AdvancedFeignClient
public interface RemoteMpAccountsService {
    /**
    * 新增记录
    */
	Boolean save(MpAccountsDto dto);

    /**
    * 根据id删除
    */
    Boolean deleteById(Long id);
    /**
    * 根据id更新
    */
    Boolean updateById(MpAccountsDto dto);
    /**
    * 根据id获取
    */
    MpAccountsDto getById(Long id);


    MpAccountsDto selectMainOAByTypeLocal(Integer type);


    MpAccountsDto getByAppId(String appId);


    /**
     * 筛选列表
     * @param queryPageParam
     * @return
     */
    List<MpAccountsDto> querypageList(QueryPageParam queryPageParam);

    /**
     * 获取总数量
     * @param queryPageParam
     * @return
     */
    Integer countPage(QueryPageParam queryPageParam);


}
