package cn.com.duiba.duiba.qutui.center.api.remoteservice.mpAuth.openpl;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.qutui.center.api.dto.auth.mpDetail.*;
import cn.com.duiba.duiba.qutui.center.api.dto.auth.mpDetail.ComponentAuditStatusDto;
import cn.com.duiba.duiba.qutui.center.api.dto.auth.mpDetail.ComponentAuditedDto;
import cn.com.duiba.duiba.qutui.center.api.dto.auth.mpDetail.audit.ComponentAuditQueryQuotaDto;
import cn.com.duiba.duiba.qutui.center.api.dto.auth.mpDetail.category.ComponentCategoryAllDto;
import cn.com.duiba.duiba.qutui.center.api.dto.auth.mpDetail.category.ComponentSetCategoryDto;
import cn.com.duiba.duiba.qutui.center.api.dto.auth.mpDetail.dataanly.*;
import cn.com.duiba.duiba.qutui.center.api.dto.auth.mpDetail.operation.*;
import cn.com.duiba.duiba.qutui.center.api.dto.auth.mpDetail.subscribe.*;
import cn.com.duiba.duiba.qutui.center.api.dto.wxmessage.WxBaseResponse;
import cn.com.duiba.duiba.qutui.center.api.param.mpAccount.*;
import cn.com.duiba.duiba.qutui.center.api.param.mpAccount.audit.ComponentAuditStatusParam;
import cn.com.duiba.duiba.qutui.center.api.param.mpAccount.audit.ComponentAuditSubmitParam;
import cn.com.duiba.duiba.qutui.center.api.param.mpAccount.audit.ComponentUploadAuditMediaParam;
import cn.com.duiba.duiba.qutui.center.api.param.mpAccount.category.ComponentAddCategoryListParam;
import cn.com.duiba.duiba.qutui.center.api.param.mpAccount.category.ComponentAddCategoryParam;
import cn.com.duiba.duiba.qutui.center.api.param.mpAccount.category.ComponentDelCategoryParam;
import cn.com.duiba.duiba.qutui.center.api.param.mpAccount.operation.ComponentErrorLogSearchParam;
import cn.com.duiba.duiba.qutui.center.api.param.mpAccount.operation.ComponentFeedbackParam;
import cn.com.duiba.duiba.qutui.center.api.param.mpAccount.operation.ComponentPerformanceSearchParam;
import cn.com.duiba.duiba.qutui.center.api.param.mpAccount.operation.ComponentUserLogSearchParam;
import cn.com.duiba.duiba.qutui.center.api.param.mpAccount.subscribe.ComponentSubTemplateAddParam;
import cn.com.duiba.duiba.qutui.center.api.param.mpAccount.subscribe.ComponentSubTemplateDelParam;
import cn.com.duiba.duiba.qutui.center.api.param.mpAccount.subscribe.ComponentSubTemplateTitleQueryParam;

import java.text.ParseException;
import java.util.List;

/**
 * @author xiaotian
 * @date 2020/11/24 11:50 下午
 */
@AdvancedFeignClient
public interface RemoteComponentMpInfoService {
    /**
     * 1、在授权成功后，根据authCode获取授权公众号的AuthInfo
     * 2、根据authInfo的appId获取oa accountInfo
     * 3、保存授权公众号到数据库
     * @param authCode 授权码
     * @return 0：失败 1：成功
     */
    int saveAuthedOaInfo(String authCode);

    /**
     * 取消授权
     * @param appId 取消授权的appId
     * @return 0：失败 1：成功
     */
    int cancelAuthedOaInfo(String appId);

    /**
     * 第三方服务平台测试用例
     * 微信要求必须有。
     */
    void openPlTestCase(String authCode, String openId);


    /**
     * 根据授权公众号的appID获取账号信息
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/Mini_Program_Information_Settings.html">文档详情</a>
     * @param appId 公众号ID
     * @return 账号信息
     */
    ComponentMpDetailInfoDto getMpBaseInfoByAppId(String appId);

    /**
     * 对小程序的域名进行操作，增删改查
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/Server_Address_Configuration.html">文档详情</a>
     * @param param
     * @return
     */
    ComponentDomainInfoDto modifyDomianInfo(ModifyServerDomainParam param);


    /**
     * 对小程序的域名进行操作，增删改查
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/setwebviewdomain.html">文档详情</a>
     * @param param
     * @return
     */
    ComponentWebViewDomainInfoDto modifyWebViewDomianInfo(ModifyWebViewDomainParam param);

    /**
     * 获取订阅消息列表
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/subscribe_template/list_template.html">文档详情</a>
     * @param appId
     * @return
     */
    ComponentSubTemplateListDto getTemplateList(String appId);

    /**
     * 绑定体验者
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/Admin.html">文档详情</a>
     * @param param
     * @return
     */
    ComponentBindTesterInfoDto bindTester( BindTesterParam param);

    /**
     * 解绑体验者
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/unbind_tester.html">文档详情</a>
     * @param param
     * @return
     */
    WxBaseResponse unBindTester(UnbindTesterParam param);

    /**
     * 获取体验者列表
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/memberauth.html">文档详情</a>
     * @param appId
     * @return
     */
    List<ComponentBindTesterInfoDto> getTesters(String appId);

    /**
     * 更新代码模版库
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/Code_Template_Library_Management.html">文档详情</a>
     */
    void refreshCodeTemplate();

    /**
     * 获取代码模版列表
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/code_template/gettemplatelist.html">文档详情</a>
     * @return
     */
    List<ComponentCodeTemplateInfoDto> getCodeTemplateList();

    /**
     * 获取各个小程序版本内容
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/Code.html">文档详情</a>
     * @param param
     * @return
     */
    List<ComponentAccountVersionDto> getAccountVersionList(QueryPageAccountVersionParam param);

    /**
     * 获取某个小程序下的版本列表
     * @param appId
     * @return
     */
    List<ComponenCodeVersionDto> getCodeVersionListDto(String appId);

    /**
     * 提交代码至体验版
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/code/commit.html">文档详情</a>
     * @param param
     */
    WxBaseResponse codeCommit(CodeCommitParam param);

    /**
     * 获取体验版二维码信息
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/code/get_qrcode.html">文档详情</a>
     * @param appId
     * @param path
     * @return
     */
    ComponentTestQRCodeDto getTestQRCode(String appId,String path);

    /**
     * 提交审核
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/code/submit_audit.html">文档详情</a>
     * @param param
     * @return
     */
    ComponentAuditedDto sumbitAudit(ComponentAuditSubmitParam param);

    /**
     * 审核版本代码上线
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/code/release.html">文档详情</a>
     * @param param
     */
    WxBaseResponse codeRelease(ComponentCodeReleaseParam param);

    /**
     * 删除代码模版
     *  <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/code_template/deletetemplate.html">文档详情</a>
     * @param paramBean
     */
    WxBaseResponse deleteCodeTemplate(ComponentDelCodeTempParam paramBean);

    /**
     * 获取提交代码页面路径
     *  <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/code/get_page.html">文档详情</a>
     * @param appId
     * @return
     */
    List<String> getCommitCodePageList(String appId);

    /**
     * 加急审核
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/code/speedup_audit.html">文档详情</a>
     * @param appId
     * @return
     */
    WxBaseResponse speedAudit(String appId);

    /**
     * 取消审核
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/code/undocodeaudit.html">文档详情</a>
     * @param appId
     * @return
     */
    WxBaseResponse cancelAudit(String appId);

    /**
     * 获取可回退版本列表
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/code/get_history_version.html">文档详情</a>
     * @param appId
     * @return
     */
    ComponentRevertCodeTempListInfoDto getRevertTempList(String appId);

    /**
     * 版本回退
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/code/revertcoderelease.html">文档详情</a>
     * @param param
     * @return
     */
    WxBaseResponse revertCodeRelease(ComponentRevertCodeReleaseParam param);

    /**
     * 查询审核状态
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/code/get_auditstatus.html">文档详情</a>
     * @param param
     * @return
     */
    ComponentAuditStatusDto auditStatus(ComponentAuditStatusParam param);

    /**
     * 查询最新的审核状态
     *  <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/code/get_latest_auditstatus.html">文档详情</a>
     * @param appId
     * @return
     */
    ComponentLastestAuditStatusDto getLastestAuditStatus(String appId);

    /**
     * 获取正式版二维码（不限制）
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/qrcode/getwxacodeunlimit.html">文档详情</a>
     * @param param
     * @return
     */
    ComponentQRCodeDto getUnlimitQRCode(ComponentWXACodeUnlimitParam param);


    /**
     * 上传临时素材
     * <a https://developers.weixin.qq.com/doc/offiaccount/Asset_Management/New_temporary_materials.html">文档详情</a>
     * @param param
     * @return
     */
    ComponentUploadTempMediaDto uploadTempMedia(ComponentUploadTempMediaParam param);


    /**
     * 上传审核素材
     * <a https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/code/submit_audit.html">文档详情</a>
     * @param param
     * @return
     */
    ComponentUploadAuditMediaDto uploadAuditMedia(ComponentUploadAuditMediaParam param);

    /**
     * 获取订阅消息类目列表
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/subscribe_template/get_category.html">文档详情</a>
     * @param appId
     * @return
     */
    ComponentSubTemplateCategoriesDto getSubTemplateCategoryList(String appId);

    /**
     * 获取订阅消息标题列表
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/subscribe_template/get_category.html">文档详情</a>
     * @param param
     * @return
     */
    ComponentSubTemplateTitlesDto getSubTemplateTitleList(ComponentSubTemplateTitleQueryParam param);

    /**
     * 获取订阅消息关键字列表
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/subscribe_template/library_get.html">文档详情</a>
     * @param appId
     * @param tid
     * @return
     */
    ComponentSubTemplateKeywordsDto getSubTemplateKeywordList(String appId, String tid);

    /**
     * 添加消息模版
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/subscribe_template/add_template.html">文档详情</a>
     * @param paramBean
     * @return
     */
    ComponentSubTemplateAddDto addSubTemplate(ComponentSubTemplateAddParam paramBean);

    /**
     * 删除订阅消息模版
     *  <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/subscribe_template/del_template.html">文档详情</a>
     * @param paramBean
     * @return
     */
    WxBaseResponse delSubTemplate(ComponentSubTemplateDelParam paramBean);

    /**
     * 修改小程序头像
     *  <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/modifyheadimage.html">文档详情</a>
     * @param paramBean
     * @return
     */
    WxBaseResponse changeMpHead(ComponentParamHeadParam paramBean);


    /**
     * 修改简介
     *  <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/modifysignature.html">文档详情</a>
     * @param paramBean
     * @return
     */
    WxBaseResponse changeSignature(ComponentParamSignatureParam paramBean);

    /**
     * 查询支持版本信息
     *  <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/code/getweappsupportversion.html">文档详情</a>
     * @param appId
     * @return
     */
    ComponentSupportVersionDto getMpSupportVersion(String appId);

    /**
     * 设置最低支持版本信息
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/code/setweappsupportversion.html">文档详情</a>
     * @param paramBean
     * @return
     */
    WxBaseResponse setMpSupportVersion(ComponentParamSetSupportVersionParam paramBean);

    /**
     * 查看类目列表
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/category/getallcategories.html">文档详情</a>
     * @param appId
     * @return
     */
    ComponentCategoryAllDto getAllCategories(String appId);

    /**
     * 获取已设置类目列表
     *  <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/category/getcategory.html">文档详情</a>
     * @param appId
     * @return
     */
    ComponentSetCategoryDto getCategories(String appId);

    /**
     * 添加类目
     *  <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/category/addcategory.html">文档详情</a>
     * @param paramBean
     * @return
     */
    WxBaseResponse addCategory(ComponentAddCategoryListParam paramBean);

    /**
     * 删除类目
     * <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/category/deletecategory.html">文档详情</a>
     * @param paramBean
     * @return
     */
    WxBaseResponse delCategory(ComponentDelCategoryParam paramBean);

    /**
     * 修改类目
     *  <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/category/modifycategory.html">文档详情</a>
     * @param paramBean
     * @return
     */
    WxBaseResponse modifyCategory(ComponentAddCategoryParam paramBean);
    /**
     * 查询反馈列表
     *  <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/operation/operation.getFeedback.html">文档详情</a>
     * @param paramBean
     * @return
     */
    ComponentFeedbackDto getFeedbackList(ComponentFeedbackParam paramBean);

    /**
     * 错误日志查询
     *  <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/operation/operation.getJsErrSearch.html">文档详情</a>
     * @param paramBean
     * @return
     */
    ComponentErrorLogDto errorLogSearch(ComponentErrorLogSearchParam paramBean);

    /**
     * 获取监控数据
     *  <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/operation/operation.getPerformance.html">文档详情</a>
     * @param paramBean
     * @return
     */
    ComponentPerformanceLogDto getPerformanceLog(ComponentPerformanceSearchParam paramBean);

    /**
     * 获取访问来源
     *  <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/operation/operation.getSceneList.html">文档详情</a>
     * @param appId
     * @return
     */
    ComponentSceneDto getScene(String appId);
    /**
     *查询实时日志
     *  <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/operation/operation.realtimelogSearch.html">文档详情</a>
     * @param paramBean
     * @return
     */
    ComponentUserLogDto userLogSearch(ComponentUserLogSearchParam paramBean);

    /**
     * 获取客户端版本
     *  <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/operation/operation.getVersionList.html">文档详情</a>
     * @param appId
     * @return
     */
    ComponentClientVersionDto getClientVersion(String appId);

    /**
     * 获取用户访问小程序数据概况
     * https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/data_analysis/analysis.getDailySummary.html
     * @param paramBean
     * @return
     */
    ComponentAnalysisSummaryTrendDto analysisSummaryTrend(ComponentAnalysisParam paramBean);

    /**
     * 获取小程序用户画像数据
     * https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/data_analysis/analysis.getUserPortrait.html
     * @param paramBean
     * @return
     */
    ComponentAnalysisUserPortraitDto analysisUserPortrait(ComponentAnalysisParam paramBean);

    /**
     * 获取小程序访问分布数据
     * https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/data_analysis/analysis.getVisitDistribution.html
     * @param paramBean
     * @return
     */
    ComponentAnalysisVisitDistributionListDto analysisVisitDistribution(ComponentAnalysisParam paramBean);

    /**
     *获取小程序访问页面数据
     * https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/data_analysis/analysis.getVisitPage.html
     * @param paramBean
     * @return
     */
    ComponentAnalysisVisitPageDto analysisVisitPage(ComponentAnalysisParam paramBean);

    /**
     * 分析存留
     * https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/data_analysis/visit-retain/analysis.getDailyRetain.html
     * @param paramBean
     * @return
     */
    ComponentAnalysisUserRetainListDto analysisRetain(ComponentAnalysisParam paramBean);


    /**
     * 数据趋势
     * https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/data_analysis/visit-trend/analysis.getDailyVisitTrend.html
     * @param paramBean
     * @return
     */
    ComponentAnalysisVisitTrendDto analysisVisitTrend(ComponentAnalysisParam paramBean);

    /**
     * 查询服务商的当月提审限额（quota）和加急次数
     * https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/Mini_Programs/code/query_quota.html
     * @param appId
     * @return
     */
    ComponentAuditQueryQuotaDto queryQuota(String appId);
}
