package cn.com.duiba.duiba.qutui.center.api.remoteservice.task;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.qutui.center.api.dto.task.ProjectEventDto;

import java.util.List;

/**
* 项目与事件的关联关系 RemoteService
* @author xiaotian
* 2021-3-16 15:36:54
*/
@AdvancedFeignClient
public interface RemoteProjectEventService {
    /**
    * 新增记录
    */
	Boolean save(ProjectEventDto dto);

    /**
    * 根据id删除
    */
    Boolean deleteById(Long id);
    /**
    * 根据id更新
    */
    Boolean updateById(ProjectEventDto dto);
    /**
    * 根据id获取
    */
    ProjectEventDto getById(Long id);

    /**
     * 根据项目Id获取事件列表
     * @param projectId
     * @return
     */
    List<ProjectEventDto> selectByProjectId(Long projectId);

}
