package cn.com.duiba.duiba.qutui.center.api.result;

import cn.com.duiba.duiba.qutui.center.api.exception.ErrorCode;

import java.io.Serializable;

/**
 * @author linzhou
 * @version 1.0.0
 * @ClassName RemoteResult.java
 * @Description quTui返回类
 * @createTime 2021年03月16日 17:49:00
 */
public class QuTuiResult<T> implements Serializable {
    private Boolean success;
    private String code;
    private String desc;
    private T data;

    private QuTuiResult(boolean success, T data, String desc) {
        this.success = success;
        this.desc = desc;
        this.data = data;
    }

    private QuTuiResult(Boolean success, String code, String desc, T data) {
        this.success = success;
        this.code = code;
        this.desc = desc;
        this.data = data;
    }

    public static <T> QuTuiResult<T> success() {
        return new QuTuiResult<>(true, ErrorCode.SUCCESS_CODE.getCode(), null, null);
    }

    public static <T> QuTuiResult<T> success(T data) {
        return new QuTuiResult<>(true,ErrorCode.SUCCESS_CODE.getCode(), null, data);
    }

    public static <T> QuTuiResult<T> fail(String message) {
        return new QuTuiResult<>(false, null, message);
    }

    public static <T> QuTuiResult<T> fail(String code, String message) {
        return new QuTuiResult<>(false, code, message, null);
    }

    public static <T> QuTuiResult<T> getInstance(boolean success) {
        return new QuTuiResult<>(success, null, null, null);
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public Boolean getSuccess() {
        return success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
