package cn.com.duiba.duiba.qutui.center.api.remoteservice.task;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.qutui.center.api.dto.task.EventDto;
import cn.com.duiba.duiba.qutui.center.api.result.PageResult;

import java.util.List;

/**
 * 事件表 RemoteService
 *
 * @author xiaotian
 * 2021-3-16 15:35:49
 */
@AdvancedFeignClient
public interface RemoteEventService {
    /**
     * 新增记录
     */
    Boolean save(EventDto dto);

    /**
     * 根据id删除
     */
    Boolean deleteById(Long id);

    /**
     * 根据id更新
     */
    Boolean updateById(EventDto dto);

    /**
     * 根据id获取
     */
    EventDto getById(Long id);

    String generatorEventStatisticsNum();

    EventDto addEvent(Long createId, Long setupId, EventDto eventDto) throws BizException;

    /**
     * 获取当前机构的事件
     * @param setupId
     * @param eventName
     * @param eventStatus
     * @param pageNum
     * @param pageSize
     * @return
     * @throws BizException
     */
    PageResult<EventDto> getEventBySetup(Long setupId, String eventName, Integer eventStatus, Integer pageNum, Integer pageSize) throws BizException;

    /**
     * 获取当前机构及所有机构的事件
     * @param setupId
     * @param eventName
     * @param eventStatus
     * @param pageNum
     * @param pageSize
     * @return
     * @throws BizException
     */
    PageResult<EventDto> getFamilyEventBySetup(Long setupId, String eventName, Integer eventStatus, Integer pageNum, Integer pageSize) throws BizException;

    EventDto updateEvent(Long modifiedId, EventDto newEvent) throws BizException;

    Boolean updateEventStatus(Long modifiedId, List<Long> eventIds, Integer status) throws BizException;


}
