package cn.com.duiba.duiba.qutui.center.api.result.task;

import cn.com.duiba.duiba.qutui.center.api.dto.setup.SetupDto;
import cn.com.duiba.duiba.qutui.center.api.dto.staff.StaffDto;
import cn.com.duiba.duiba.qutui.center.api.dto.task.StaffGradeDto;
import lombok.Data;

import java.io.Serializable;

/**
 * @author linzhou
 * @version 1.0.0
 * @ClassName ProjectStaffSortResult.java
 * @Description TODO
 * @createTime 2021年03月25日 10:41:00
 */
@Data
public class ProjectStaffSortResult implements Serializable {

    /**
     * 机构名称
     */
    private String setupName;
    /**
     * 机构id
     */
    private Long setupId;
    /**
     * 排名
     */
    private Integer gradeRank;

    private String staffName;

    private String staffAvatar;

    /**
     * 总分
     */
    private Double allGrade;

    public ProjectStaffSortResult(StaffGradeDto staffGradeDto, StaffDto staffDto, SetupDto setup) {
        setupName = setup.getSetupName();
        setupId = setup.getId();
        gradeRank = staffGradeDto.getGradeRank();
        staffName = staffDto.getStaffName();
        staffAvatar = staffDto.getStaffAvatar();
        allGrade = staffGradeDto.getAllGrade();
    }

    public ProjectStaffSortResult(int gradeRank, StaffDto staffDto, SetupDto setup) {
        setupName = setup.getSetupName();
        setupId = setup.getId();
        this.gradeRank = gradeRank;
        staffName = staffDto.getStaffName();
        staffAvatar = staffDto.getStaffAvatar();
        allGrade = 0D;
    }
}
