/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.duiba.qutui.center.api.util;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.duiba.qutui.center.api.exception.ErrorCode;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Assert {
    private static final Logger log = LoggerFactory.getLogger(Assert.class);

    public static void isBlank(String str, ErrorCode code, String errorMsg) throws BizException {
        Assert.isTrue(StringUtils.isBlank((CharSequence)str), code, errorMsg);
    }

    public static void isNotBlank(String str, ErrorCode code, String errorMsg) throws BizException {
        Assert.isTrue(StringUtils.isNotBlank((CharSequence)str), code, errorMsg);
    }

    public static void isEmpty(String str, ErrorCode code, String errorMsg) throws BizException {
        Assert.isTrue(StringUtils.isEmpty((CharSequence)str), code, errorMsg);
    }

    public static void isNotEmpty(String str, ErrorCode code, String errorMsg) throws BizException {
        Assert.isTrue(StringUtils.isNotEmpty((CharSequence)str), code, errorMsg);
    }

    public static void isNotNull(Object o, ErrorCode code, String errorMsg) throws BizException {
        Assert.isTrue(o != null, code, errorMsg);
    }

    public static void isNull(Object o, ErrorCode code, String errorMsg) throws BizException {
        Assert.isTrue(o == null, code, errorMsg);
    }

    public static void isNotEmpty(Collection c, ErrorCode code, String errorMsg) throws BizException {
        Assert.isTrue(CollectionUtils.isNotEmpty((Collection)c), code, errorMsg);
    }

    public static void isEmpty(Collection c, ErrorCode code, String errorMsg) throws BizException {
        Assert.isTrue(CollectionUtils.isEmpty((Collection)c), code, errorMsg);
    }

    public static void isMapNotEmpty(Map m, ErrorCode code, String errorMsg) throws BizException {
        Assert.isTrue(m != null && !m.isEmpty(), code, errorMsg);
    }

    public static void isMapEmpty(Map m, ErrorCode code, String errorMsg) throws BizException {
        Assert.isTrue(m == null || m.isEmpty(), code, errorMsg);
    }

    public static void isTrue(boolean as, ErrorCode code, String errorMsg) throws BizException {
        if (code == null) {
            code = ErrorCode.ERROR;
        }
        if (!as) {
            log.info("ErrorCode = {},errorMsg = {}", (Object)code, (Object)errorMsg);
            throw new BizException(errorMsg).withCode(code.getCode());
        }
    }
}

