package cn.com.duiba.duiba.qutui.center.api.dto.task;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.duiba.qutui.center.api.enums.StaffIdentityEnum;
import cn.com.duiba.duiba.qutui.center.api.exception.ErrorCode;
import cn.com.duiba.duiba.qutui.center.api.util.Assert;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 项目下发员工类型
* 2021-3-19 15:11:35
*/
@Data
public class ProjectPushStaffDto implements Serializable {

    /**
    * 事件id,主键，自增
    */
    private Long id;

    /**
    * 项目id
    */
    private Long projectId;

    /**
    * 员工类型
    */
    private Integer pushStaffIdentity;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

    public void check() throws BizException {
        StaffIdentityEnum staffIdentityEnum = StaffIdentityEnum.getEnum(pushStaffIdentity);
        Assert.isNotNull(staffIdentityEnum,ErrorCode.PARAM_ERROR,"推广员工类型不能为空!");
    }
}

