package cn.com.duiba.duiba.qutui.center.api.dto.task;

import cn.com.duiba.duiba.qutui.center.api.util.MathUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * 机构历史业绩
 * 2021-3-22 17:56:13
 */
@Data
public class SetupGradeDto implements Serializable {

    /**
     * 总分
     */
    private Double allGrade;

    /**
     * 批次id
     */
    private String batchId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 所属机构下的本机构的排名
     */
    private Integer gradeRank;

    /**
     * id,主键，自增
     */
    private Long id;

    /**
     * 项目id
     */
    private Long projectId;

    /**
     * 子机构总分
     */
    private Double setupChildrenGrade;

    /**
     * 机构id
     */
    private Long setupId;

    /**
     * 本机构分数
     */
    private Double setupSelfGrade;

    /**
     * 业绩明细
     */
    private String gradeDetail;

    public List<SetupStaffIdentityGradeDetailDto> getStaffIdentityGrades() {
        return Optional.ofNullable(gradeDetail)
                .map(JSON::parseObject)
                .map(o -> o.getJSONArray("staffIdentityGrade"))
                .map(o -> o.toJavaList(SetupStaffIdentityGradeDetailDto.class))
                .orElse(new ArrayList<>());
    }

    public List<EventGradeDto> getEventGrades() {
        return Optional.ofNullable(gradeDetail)
                .map(JSON::parseObject)
                .map(o -> o.getJSONArray("eventGradeDto"))
                .map(o -> o.toJavaList(EventGradeDto.class))
                .orElse(new ArrayList<>());
    }

    public void addGradeDetail(Collection<EventGradeDto> eventGradeDtos,
                               Collection<SetupStaffIdentityGradeDetailDto> setupStaffIdentityGradeDetailDtos) {
        JSONObject json = new JSONObject();
        if (CollectionUtils.isNotEmpty(eventGradeDtos)) {
            json.put("eventGradeDto", eventGradeDtos);
        }
        if (CollectionUtils.isNotEmpty(setupStaffIdentityGradeDetailDtos)) {
            json.put("staffIdentityGrade", setupStaffIdentityGradeDetailDtos);
        }
        gradeDetail = json.toJSONString();
    }

    public void addChildSetupGrade(SetupGradeDto childSetupGrade) {
        if (childSetupGrade == null){
            return;
        }

        allGrade = MathUtil.add(allGrade,childSetupGrade.getSetupSelfGrade());
        setupChildrenGrade = MathUtil.add(setupChildrenGrade,childSetupGrade.getSetupSelfGrade());
        //计算用户身份业绩
        Map<Integer, SetupStaffIdentityGradeDetailDto> identity2Grade = getStaffIdentityGrades()
                .stream()
                .collect(Collectors.toMap(SetupStaffIdentityGradeDetailDto::getStaffIdentity, o -> o));
        List<SetupStaffIdentityGradeDetailDto> staffIdentityGrades = childSetupGrade.getStaffIdentityGrades();
        for (SetupStaffIdentityGradeDetailDto staffIdentityGrade : staffIdentityGrades) {
            SetupStaffIdentityGradeDetailDto identityGrade = identity2Grade.get(staffIdentityGrade.getStaffIdentity());
            if (identityGrade == null){
                identity2Grade.put(staffIdentityGrade.getStaffIdentity(),staffIdentityGrade.copy());
            }else {
                identityGrade.mergeGrade(staffIdentityGrade);
            }
        }
        //计算事件业绩
        Map<Long, EventGradeDto> eventId2Grade = getEventGrades()
                .stream().collect(Collectors.toMap(EventGradeDto::getEventId, o -> o));
        List<EventGradeDto> eventGrades = childSetupGrade.getEventGrades();
        for (EventGradeDto eventGrade : eventGrades) {
            EventGradeDto dto = eventId2Grade.get(eventGrade.getEventId());
            if (dto == null){
                eventId2Grade.put(eventGrade.getEventId(),eventGrade.copy());
            }else {
                dto.mergeEventGrade(eventGrade);
            }
        }

        addGradeDetail(eventId2Grade.values(),identity2Grade.values());
    }
}

