package cn.com.duiba.duiba.qutui.center.api.remoteservice.mpAuth.openpl;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/api/component_verify_ticket.html
 * component_verify_ticket：获取component_access_token的验证票据
 * 有效期：12小时
 * 更新周期：10分钟
 * @author xiaotian
 * @date 2020/11/23 2:35 下午
 */
@AdvancedFeignClient
public interface RemoteComponentVerifyTicketService {

    /**
     * 保存ticket。
     * @param ticket 获取component_access_token的验证票据
     * @param appId 开放平台的appID
     */
    void saveTicket(String appId, String ticket);
}
