package cn.com.duiba.duiba.qutui.center.api.remoteservice.setup;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.qutui.center.api.dto.setup.SetupUserDto;
import cn.com.duiba.duiba.qutui.center.api.dto.setup.SetupUserSimpleDto;
import cn.com.duiba.duiba.qutui.center.api.param.setup.SetupUserChangePasswordParam;
import cn.com.duiba.duiba.qutui.center.api.param.setup.SetupUserResetPasswordParam;
import cn.com.duiba.duiba.qutui.center.api.param.setup.SetupUsersPageQuery;
import cn.com.duiba.duiba.qutui.center.api.result.PageResult;

import cn.com.duiba.duiba.qutui.center.api.result.setup.RegisterSetupUserResult;

/**
 * 机构账户表 RemoteService
 *
 * @author xiaotian
 * 2021-3-16 17:47:09
 */
@AdvancedFeignClient
public interface RemoteSetupUserService {

    SetupUserDto getById(Long id);

    SetupUserDto login(String userName, String password) throws BizException;

    SetupUserDto getBySetupId(Long setupId) throws BizException;

    /**
     * 添加子账户
     *
     * @param setupId
     * @return
     * @throws BizException
     */
    RegisterSetupUserResult registerSetupUser(Long setupId, Long userPhone) throws BizException;

    /**
     * 重置管理员密码
     *
     * @param param
     * @return
     * @throws BizException
     */
    SetupUserDto resetPassword(SetupUserResetPasswordParam param) throws BizException;

    /**
     * 修改管理员密码
     *
     * @param changePassword
     * @return
     * @throws BizException
     */
    Boolean changePassword(SetupUserChangePasswordParam changePassword) throws BizException;

    /**
     * 分页获取机构管理员
     *
     * @param query
     * @return
     */
    PageResult<SetupUserSimpleDto> pageSetupUsers(SetupUsersPageQuery query);


}
