package cn.com.duiba.service.domain.dataobject;

import cn.com.duiba.service.domain.BaseDO;

import java.util.Date;

public class AppTagsMaskingDO extends BaseDO {
	private Long id;
	private Long appId;
	private Long tagsId;

	private Date gmtCreate;
	private Date gmtModified;
	
	public AppTagsMaskingDO(boolean init4insert) {
		if (init4insert) {
			toBeInsert = true;
			gmtCreate = new Date();
			gmtModified = new Date();
		}
	}

	public AppTagsMaskingDO() {
	}

	public AppTagsMaskingDO(Long id) {
		this.id = id;
		this.gmtModified = new Date();
		toBeUpdate = true;
	}

	public void beforeUpdate() {
		gmtModified = new Date();
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Long getTagsId() {
		return tagsId;
	}

	public void setTagsId(Long tagsId) {
		this.tagsId = tagsId;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}
}
