package cn.com.duiba.service.item.remoteservice;

import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.item.domain.dataobject.AppItemClassifyDO;

import java.util.List;
import java.util.Map;

public interface RemoteAppItemClassifyService {

	public Long findByCount(Map<String, Object> params);

	public List<AppItemClassifyDO> findByLimit(Map<String, Object> params);

	public List<AppItemClassifyDO> findAllByAppId(Long appId);
	
	public int batchInsert(List<Map<String, Object>> classifyRelation);
	
	public List<Long> findAllAppItemById(Long classifyId);
	
	public int deleteAppItemRelation(List<Long> ids, Long appId);
	
	public void insert(AppItemClassifyDO appItemClassifyDO);
	
	public AppItemClassifyDO find(Long id);
	
	public void update(AppItemClassifyDO appItemClassifyDO);
	
	public int deleteClassifyAppItem(Long classifyId, Long appItemId);
	
	public List<AppItemDO> findClassifyAppItems(Long classifyId, Long appId, String status, Integer start, Integer pageSize);
	
	public List<AppItemDO> findAppItemNoExistClassify(Map<String, Object> query, Integer start, Integer pageSize);
	
	public Integer findAppItemNoExistClassifyCount(Map<String, Object> query);
	
	public Integer deleteClassifyAllAppItem(Long classifyId);
	
	public Integer deleteRelationAppItem(Long appItemId);
	
	public Integer findMaxPayload(Long classifyId);
	
	public Integer updatePayload(Long appItemId, Long classifyId, Integer payload);

	public List<AppItemClassifyDO> findByIds(List<Long> ids);
}
