package cn.com.duiba.service.item.domain.dataobject;

import cn.com.duiba.service.domain.BaseDO;

import java.util.Date;

public class ItemStockSpecifyConsumeDO extends BaseDO{
	private static final long serialVersionUID = 1213223211232L;

	public static final String TYPE_DUIBA = "item";
	public static final String TYPE_DEV_ITEM = "appItem";
	public static final String ACTION_PAY = "pay";
	public static final String ACTION_BACK = "back";
	public static final String BIZ_SOURCE_SPECIFY = "normalspecify";//普通定向商品
	public static final String BIZ_SOURCE_SINGLE_SPECIFY = "singlespecify";//单品定向
	public static final String BIZ_SOURCE_TURNTABLE_SPECIFY = "turntablespecify";//大转盘定向
	public static final String BIZ_SOURCE_HDTOOL_SPECIFY = "hdtoolspecify";//活动工具定向
	public static final String BIZ_SOURCE_GAME_SPECIFY = "gamespecify";//活动工具定向
	public static final String BIZ_SOURCE_QUESTION_SPECIFY = "questionspecify";//答题定向
	public static final String BIZ_SOURCE_QUIZZ_SPECIFY = "quizzspecify";//测试题定向
	
	private Long id;
	private Long relationId;
	private String relationType;
	private String bizId;
	private String bizSource;
	private String action;
	private Long quantity;
	private Long appId;
	private Date gmtCreate;
	private Date gmtModified;
	
	public ItemStockSpecifyConsumeDO(boolean init4insert) {
		if (init4insert) {
			toBeInsert = true;
			gmtCreate = new Date();
			gmtModified = new Date();
		}
	}

	public ItemStockSpecifyConsumeDO() {
	}

	public ItemStockSpecifyConsumeDO(Long id) {
		this.id = id;
		this.gmtModified = new Date();
		toBeUpdate = true;
	}
	
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public Long getRelationId() {
		return relationId;
	}
	public void setRelationId(Long relationId) {
		this.relationId = relationId;
	}
	public String getRelationType() {
		return relationType;
	}
	public void setRelationType(String relationType) {
		this.relationType = relationType;
	}
	public String getBizId() {
		return bizId;
	}
	public void setBizId(String bizId) {
		this.bizId = bizId;
	}
	public String getBizSource() {
		return bizSource;
	}
	public void setBizSource(String bizSource) {
		this.bizSource = bizSource;
	}
	public String getAction() {
		return action;
	}
	public void setAction(String action) {
		this.action = action;
	}
	public Long getQuantity() {
		return quantity;
	}
	public void setQuantity(Long quantity) {
		this.quantity = quantity;
	}
	public Long getAppId() {
		return appId;
	}
	public void setAppId(Long appId) {
		this.appId = appId;
	}
	public Date getGmtCreate() {
		return gmtCreate;
	}
	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}
	public Date getGmtModified() {
		return gmtModified;
	}
	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}
	
	
}
