package cn.com.duiba.service.item.remoteservice;

import cn.com.duiba.service.item.domain.dataobject.ItemTagsDO;

import java.util.List;

/**
 * Created by wenqi.huang on 16/5/11.
 */
public interface RemoteItemTagsService {
    /**
     * 根据itemId和tagsId查询ItemTags
     *
     */
    public ItemTagsDO findByItemAndTags(Long itemId, Long tagsId);

    /**
     * 根据tagsId查询ItemTags
     *
     * @param tagsId
     * @return
     */
    public List<ItemTagsDO> findByTags(Long tagsId);

    /**
     * 删除ItemTags记录
     *
     * @param id
     */
    public void delete(Long id);

    /**
     * 删除ItemTags记录
     */
    public void deleteByItemId(Long itemId);

    /**
     * 包含该标签的兑换项数
     */
    public Integer countByTagsId(Long tagsId);

    /**
     * 根据itemId获取list
     */
    public List<ItemTagsDO> findAllByItemId(Long itemId);

    /**
     * 根据tagsId删除
     */
    public void deleteByTagsId(Long tagsId);

    public void insert(ItemTagsDO itemTagsDO);
}
