package cn.com.duiba.service.item.remoteservice;

import cn.com.duiba.service.item.domain.dataobject.OperatingActivityDO;
import cn.com.duiba.service.item.domain.vo.ActivityVO;

import java.util.List;
import java.util.Map;

public interface RemoteOperatingActivityService {

	public List<OperatingActivityDO> findGameByAppIdAndActivityId(Long appId, List<Long> duibaActivityIds, Integer type);

	/**
	 * 获取能加到计划任务中的app活动
	 */
	public List<OperatingActivityDO> findAllAppTasksContent(Long appId);

	/**
	 * 获取开启状态的抽奖活动ids
	 */
	public List<Long> findOpenLotteryIds();

	/**
	 * 获取所有添加了此兑吧专题活动的开启并且非删除状态的开发者活动
	 */
	public List<OperatingActivityDO> findAllOpenDuibaActivity(Long duibaActivityId);

	/**
	 * @Title: findByAppIdAndDuibaActivityIdAndDeleted
	 * @Description: 根据appId和duibaActivityId获取
	 * @param appId
	 * @param duibaActivityId
	 * @return
	 */
	public OperatingActivityDO findByAppIdAndDuibaActivityIdAndDeleted(Long appId, Long duibaActivityId, Boolean deleted);

	/**
	 * 根据appId和duibaActivityId获取
	 */
	public OperatingActivityDO findByAppIdAndDuibaTurntableIdAndDeleted(Long appId, Long duibaTurntableId, Boolean deleted);

	/**
	 * 根据appId和gameConfigDuibaId获取
	 */
	public OperatingActivityDO findByAppIdAndGameConfigDuibaIdAndDeleted(Long appId, Long gameConfigDuibaId, Boolean deleted);
	
	/**
	 * 根据appId和duibaSingleLotteryId获取
	 */
	public OperatingActivityDO findByAppIdAndDuibaSingleLotteryIdAndDeleted(Long appId, Long duibaSingleLotteryId, Boolean deleted);
	
	/**
	 * 根据appId和duibaQuestionAnswerId获取
	 */
	public OperatingActivityDO findByAppIdAndDuibaQuestionAnswerIdAndDeleted(Long appId, Long duibaQuestionAnswerId, Boolean deleted);
	
	/**
	 * 根据appId和duibaSeckillId获取
	 */
	public OperatingActivityDO findByAppIdAndDuibaSeckillIdAndDeleted(Long appId, Long duibaSeckillId, Boolean deleted);

	/**
	 * 根据appId和duibaHdtoolId获取
	 */
	public OperatingActivityDO findByAppIdAndDuibaHdtoolIdAndDeleted(Long appId, Long duibaHdtoolId, Boolean deleted);
	
	/**
	 * 根据appId和duibaQuizzId获取
	 */
	public OperatingActivityDO findByAppIdAndDuibaQuizzIdAndDeleted(Long appId, Long duibaQuizzId, Boolean deleted);
	
	/**
	 * 根据appId和AppSingleLotteryId获取
	 */
	public OperatingActivityDO findByAppIdAndAppSingleLotteryIdAndDeleted(Long appId, Long appSingleLotteryId, Boolean deleted);

	public OperatingActivityDO findByAppIdAndAppManualLotteryAndDeleted(Long appId, Long appManualLotteryId, Boolean deleted);

	public Long countActivity(Map<String, Object> params);

	public List<ActivityVO> findActivityList(Map<String, Object> params);
	
	public List<ActivityVO> findRecommendActivityList(Long appId);
	

	public List<ActivityVO> findActivityListByParent(Map<String, Object> params);

	public Integer deleteTurntable(Long turntableId, Long appId, Boolean delete, Integer status);

	/**
	 * @Title: findAppIdsByDuibaActivityId
	 * @Description: 根据兑吧活动ID 获取所添加的AppId列表
	 * @return
	 */
	public List<Long> findAppIdsByDuibaActivityId(Long duibaActivityId);

	/**
	 * 根据单品抽奖ID获取APPID列表
	 */
	public List<Long> findAppIdsBySingleLotteryId(Long singleLotteryId);

	public List<Long> findAppIdsByActivityIdAndType(Long activityId, Integer type);

	/**
	 * 根据兑吧单品抽奖活动ID 获取所添加的AppId列表
	 */
	public List<Long> findAppIdsByDuibaSingleLotteryId(Long duibaSingleLotteryId);

	public Integer countAppByActivityIdAndType(Long activityId, Integer type);

	/**
	 * 根据兑吧活动ids获取List<OperatingActivityDO>
	 */
	public List<OperatingActivityDO> findAllByDuibaActivityIds(List<Long> daIdList);

	public List<OperatingActivityDO> findAllByActivityIdsAndType(List<Long> activityIds, Integer type);

	/**
	 * 根据兑吧单品抽奖ids获取List<OperatingActivityDO>
	 */
	public List<OperatingActivityDO> findAllByDuibaSingleLotteryIds(List<Long> dslIdList);

	/**
	 * 根据兑吧活动id获取List<Long>
	 */
	public List<Long> findIdsByDuibaActivityId(Long duibaActivityId);

	/**
	 * 关闭所有已经添加该duibaActivity的活动
	 */
	public int updateStatusByDuibaActivityId(Integer status, Long duibaActivityId);

	/**
	 * 关闭所有已经添加该duibaSingleLottery的活动
	 */
	public int updateStatusBySingleLotteryId(Integer status, Long singleLotteryId);

	public int updateVisitTimes(Long id);

	/**
	 * 根据兑吧单品抽奖ID获取开发者活动ids
	 */
	public List<Long> findIdsBySingleLotteryId(Long duibaSingleLotteryId);

	/**
	 * 根据类型查询所有
	 */
	public List<OperatingActivityDO> findAllByType(Integer type);

	/**
	 * 根据duibaSingleLotteryId查询
	 */
	public List<OperatingActivityDO> findAllBySingleLotteryId(Long duibaSingleLotteryId);

	public List<OperatingActivityDO> findAllBySingleLotteryIdAndDeleted(Long duibaSingleLotteryId, Boolean deleted);

	public List<OperatingActivityDO> findAllByDuibaSeckillIdAndDeleted(Long duibaSeckillId, Boolean deleted);

	public List<OperatingActivityDO> findAllByDuibaActivityId(Long duibaActivityId);

	public List<OperatingActivityDO> findAllByDuibaSecondsKillId(Long duibaSecondsKillId);

	public List<OperatingActivityDO> findAllByDuibaActivityIdAndDeleted(Long duibaActivityId, Boolean deleted);

	public List<OperatingActivityDO> findAllByDuibaQuestionAnswerIdAndDeleted(Long duibaQuestionAnswerId, Boolean deleted);

	public List<OperatingActivityDO> findAllByDuibaQuizzIdAndDeleted(Long duibaQuizzId, Boolean deleted);

	public void updateStatusByActivityIdAndType(Long activityId, Integer type, Integer status);

	public OperatingActivityDO findByActivityIdAndTypeAndAppIdAndDeleted(Long activityId, Integer type, Long appId, Boolean deleted);

	public List<Long> findIdsByDuibaActivityIdAndType(Long duibaActivityId, Integer type);

	public List<OperatingActivityDO> findSingleLotteryOperaList(List<Long> activityIds, Long appId);

	/**
	 * 用于查询子活动
	 */
	public OperatingActivityDO findByActivityIdAndParentIdAndTypeAndAppId(Long duibaActivityId, Long parentActivityId, Integer type, Long appId);

	public void deleteByParentActivityIds(List<Long> parentIds);

	public OperatingActivityDO findOperatingSingleLottery(Long activityId, Long appId);

	public List<OperatingActivityDO> findAllByIds(List<Long> ids);

	public int updateManualLotteryByIds(List<Long> ids);

	/**
	 * 查询某个App的所有正在启用状态的运营活动
	 */
	public List<OperatingActivityDO> findAllEnabledActivies(Long appId);

	/**
	 * 获取开启状态的活动
	 */
	public List<OperatingActivityDO> findActiveActivity(Long appId);

	public List<Long> findAllVirtualInTurntable(Long appId);

	public List<Long> findAllVirtualInSingleLottery(Long appId);

	public List<Long> findAllVirtualInHdTool(Long appId);
	
	public OperatingActivityDO find(Long id);
	
	public OperatingActivityDO insert(OperatingActivityDO operatingActivityDO);
	
	public int update(OperatingActivityDO operatingActivityDO);
	
	/**
	 * 根据兑吧秒杀专题活动ID 获取所添加的AppId列表
	 */
	public List<Long> findAppIdsByDuibaSecondsKillId(Long duibaSecondsKillId);

	public List<OperatingActivityDO> findAllByDuibaSecondsKillActivityId(Long duibaSecondsKillActivityId);
	
	public List<OperatingActivityDO> findAllByDuibaQuestionAnswerId(Long duibaQuestionAnswerId);

	public List<OperatingActivityDO> findAllByDuibaQuizzId(Long duibaQuizzId);

	public List<OperatingActivityDO> findAllByDuibaSeckillId(Long duibaSeckillId);

	public List<OperatingActivityDO> findAllByDuibaSecondsKillActivityIdAndDeleted(Long duibaSecondsKillActivityId, Boolean deleted);

	public void updateStatusByDuibaSecondsKillActivityId(Integer status, Long duibaSecondsKillActivityId);

	public OperatingActivityDO findGameOperatingActivity(Long appId, Long gameConfigDuibaId, Integer gameType);
	
	public OperatingActivityDO findQuestionAnswerOperatingActivity(Long appId, Long activityId);
	
	public OperatingActivityDO findSecondsKillOperatingActivity(Long appId, Long activityId);
	
	public OperatingActivityDO findByAppIdAndDuibaGameIdAndDeleted(Long appId, Long duibaGameId, Boolean deleted);

	public ActivityVO findByAppIdLimit(Long appId, Long activityId);

	//from developer project
	public List<OperatingActivityDO> findAllByAppId(Long appId);

	public OperatingActivityDO findByAppIdAndDuibaSecondsKillActivityIdAndDeleted(Long appId, Long duibaSecondsKillActivityId, Boolean deleted);

	public List<OperatingActivityDO> findDuibaQuestionAnswerByAppIdAndActivityId(Long appId, List<Long> activityIds, Integer type);

	public List<OperatingActivityDO> findDuibaQuizzByAppIdAndActivityId(Long appId, List<Long> activityIds, Integer type);

	public List<OperatingActivityDO> findDuibaSeckillByAppIdAndActivityId(Long appId, List<Long> activityIds, Integer type);

	public List<ActivityVO> findOnlineActivity(Map<String, Object> params);

	public List<ActivityVO> findOnlineActivityWithOutTopic(Map<String, Object> params);

}

