package cn.com.duiba.service.domain.dataobject;

import cn.com.duiba.wolf.utils.DateUtils;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class AppShowcaseContentDO implements Serializable{

	private static final long serialVersionUID = 1745931267L;

	public static final int PLACE_1 = 1; // 位置1
	public static final int PLACE_2 = 2; // 位置2
	public static final int PLACE_3 = 3; // 位置3

	public static final String RELATION_TYPE_ITEM = "item"; // 兑换项
	public static final String RELATION_TYPE_DUIBA_ACTIVITY = "duibaActivity"; // 兑吧专题活动
	public static final String RELATION_TYPE_DUIBA_TURNTABLE = "duibaTurntable"; // 兑吧大转盘
	public static final String RELATION_TYPE_DUIBA_SINGLE_LOTTERY = "duibaSingleLottery"; // 兑吧单品抽奖
	public static final String RELATION_TYPE_DUIBA_HDTOOL = "duibaHdtool"; // 兑吧活动工具
	public static final String RELATION_TYPE_DUIBA_QUESTION = "duibaQuestion"; // 兑吧答题活动
	public static final String RELATION_TYPE_DUIBA_GAME = "duibaGame";//兑吧游戏
	public static final String RELATION_TYPE_DUIBA_QUIZZ = "duibaQuizz";//兑吧测试题
	public static final String RELATION_TYPE_DUIBA_SECKILL = "duibaSeckill"; // 兑吧秒杀活动
	public static final String RELATION_TYPE_APP_ITEM = "appItem"; // 开发者库中的兑换项
	public static final String RELATION_TYPE_OPERATING_ACTIVITY = "operatingActivity"; // 开发者库中的活动
	public static final String RELATION_TYPE_LINK = "link"; // 链接类型

	public static final List<String> RELATION_TYPE_LIST = Arrays.asList(
			RELATION_TYPE_ITEM, RELATION_TYPE_DUIBA_ACTIVITY,
			RELATION_TYPE_DUIBA_TURNTABLE, RELATION_TYPE_DUIBA_SINGLE_LOTTERY,
			RELATION_TYPE_DUIBA_HDTOOL, RELATION_TYPE_DUIBA_QUESTION,
			RELATION_TYPE_DUIBA_GAME,RELATION_TYPE_APP_ITEM,RELATION_TYPE_DUIBA_QUIZZ,RELATION_TYPE_DUIBA_SECKILL,
			RELATION_TYPE_OPERATING_ACTIVITY, RELATION_TYPE_LINK);

	public static final List<String> RELATION_TYPE_DUIBA = Arrays.asList(
			RELATION_TYPE_ITEM, RELATION_TYPE_DUIBA_ACTIVITY,
			RELATION_TYPE_DUIBA_TURNTABLE, RELATION_TYPE_DUIBA_SINGLE_LOTTERY,
			RELATION_TYPE_DUIBA_HDTOOL, RELATION_TYPE_DUIBA_QUESTION,RELATION_TYPE_DUIBA_GAME,RELATION_TYPE_DUIBA_SECKILL,RELATION_TYPE_DUIBA_QUIZZ
			);

	public static final List<String> RELATION_TYPE_APP = Arrays.asList(
			RELATION_TYPE_APP_ITEM,
			RELATION_TYPE_OPERATING_ACTIVITY, RELATION_TYPE_LINK
			);

	private Long id;

	private Long appId;

	private Date startTime;

	private Long relationId;

	private String relationType;

	private Integer place;

	private String mainTitle;

	private String mainTitleColor;

	private String subTitle;

	private String indexImage;

	private Long showCredits;

	private String url;

	private Long duibaShowcaseTaskContentId;

	private Long duibaShowcaseTaskId;
	
	private Boolean deleted;

	private Date gmtCreate;

	private Date gmtModified;

	// 辅助字段
	private String startTimeStr;

	public String getStartTimeStr() {
		return startTimeStr;
	}

	public void setStartTimeStr(String startTimeStr) {
		this.startTimeStr = startTimeStr;
	}

	public Long getDuibaShowcaseTaskId() {
		return duibaShowcaseTaskId;
	}

	public void setDuibaShowcaseTaskId(Long duibaShowcaseTaskId) {
		this.duibaShowcaseTaskId = duibaShowcaseTaskId;
	}
	
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Date getStartTime() {
		return startTime;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
		this.startTimeStr = DateUtils.getSecondStr(this.startTime);
	}

	public Long getRelationId() {
		return relationId;
	}

	public void setRelationId(Long relationId) {
		this.relationId = relationId;
	}

	public String getRelationType() {
		return relationType;
	}

	public void setRelationType(String relationType) {
		this.relationType = relationType;
	}

	public Integer getPlace() {
		return place;
	}

	public void setPlace(Integer place) {
		this.place = place;
	}

	public String getMainTitle() {
		return mainTitle;
	}

	public void setMainTitle(String mainTitle) {
		this.mainTitle = mainTitle;
	}

	public String getMainTitleColor() {
		return mainTitleColor;
	}

	public void setMainTitleColor(String mainTitleColor) {
		this.mainTitleColor = mainTitleColor;
	}

	public String getSubTitle() {
		return subTitle;
	}

	public void setSubTitle(String subTitle) {
		this.subTitle = subTitle;
	}

	public String getIndexImage() {
		return indexImage;
	}

	public void setIndexImage(String indexImage) {
		this.indexImage = indexImage;
	}

	public Long getShowCredits() {
		return showCredits;
	}

	public void setShowCredits(Long showCredits) {
		this.showCredits = showCredits;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public Long getDuibaShowcaseTaskContentId() {
		return duibaShowcaseTaskContentId;
	}

	public void setDuibaShowcaseTaskContentId(Long duibaShowcaseTaskContentId) {
		this.duibaShowcaseTaskContentId = duibaShowcaseTaskContentId;
	}

	public Boolean getDeleted() {
		return deleted;
	}

	public void setDeleted(Boolean deleted) {
		this.deleted = deleted;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

}
