package cn.com.duiba.service.domain.dataobject;

import java.io.Serializable;
import java.util.Date;

public class DuibaGuessDO implements Serializable {

	private static final long serialVersionUID = 5758075167406488629L;
	public static final Integer SWITCHES_DIRECT = 0; // 定向发放
	public static final Integer SWITCHES_DEV_BLACKLIST = 1; // 黑名单商品

	public static final int SWITCHES_FREE_RULE = 2; // 免费次数使用的活动规则

	public static final int STATUS_OPEN = 1; // 开启且可见
	public static final int STATUS_CLOSE_SHOW = 2; // 关闭且可见
	public static final int STATUS_CLOSE = 3; // 关闭不可见
	public static final Integer LimitTypeForever = 0; // 永久:forever
	public static final Integer LimitTypeEveryday = 1; // 每天:everyday
	public static final String LimitTypeForeverStr = "forever"; // 永久:
	public static final String LimitTypeEverydayStr = "everyday"; // 每天:

	public static final String indexStatusNotLogin = "请先登录"; // 未登陆
	public static final String indexStatusEnd = "竞猜结束"; // 已结束
	public static final String indexStatuNotEnough = "积分不足"; // 积分不足
	public static final String indexStatusStart = "开始竞猜"; // 开始测试
	public static final String indexStatusNotChangeUsed = "下次再玩吧"; // 机会已用完
	public static final String indexStatusNotChangeUsedToday = "明天再玩吧"; // 今日机会已用完
	public static final String indexStatusWinList = "中奖名单"; // 中奖名单

	public static final int codeStatusStart = 0;
	public static final int codeStatusNotLogin = 1;
	public static final int codeStatusNotEnough = 2;
	public static final int codeStatusNotChangeUsed = 4;
	public static final int codeStatusNotChangeUsedToday = 3;
	public static final int codeStatusEnd = 5;
	public static final int codeStatusWinList = 6;

	private Long id;
	private String title;
	private Integer status;
	private Long creditsPrice;
	private Integer limitCount;
	private Integer limitScope;
	private Integer freeLimit;
	private Integer freeScope;
	private Long duibaGuessBrickId;
	private String rule;
	private String freeRule;
	private String banner;
	private String smallImage;
	private String whiteImage;
	private String logo;
	private String recommendImage;
	private Integer switches;
	private Boolean isOpenPrize;
	private Date autoOffDate;
	private Boolean deleted;
	private Date gmtCreate;
	private Date gmtModified;
	private String luckNum;
	private Long rightSelectionId;
	private Integer isAccurate;
	private String tag;
	
    public String getTag() {
        return tag;
    }
    
    public void setTag(String tag) {
        this.tag = tag;
    }

    private Long activityCategoryId;//活动归类 --徐恒飞

    public Long getRightSelectionId() {
        return rightSelectionId;
    }
    
    public void setRightSelectionId(Long rightSelectionId) {
        this.rightSelectionId = rightSelectionId;
    }
    
    public Integer getIsAccurate() {
        return isAccurate;
    }
    
    public void setIsAccurate(Integer isAccurate) {
        this.isAccurate = isAccurate;
    }

    public Long getDuibaGuessBrickId() {
        return duibaGuessBrickId;
    }
    
    public void setDuibaGuessBrickId(Long duibaGuessBrickId) {
        this.duibaGuessBrickId = duibaGuessBrickId;
    }
    
    public String getFreeRule() {
        return freeRule;
    }
    
    public void setFreeRule(String freeRule) {
        this.freeRule = freeRule;
    }
    
    public Boolean getIsOpenPrize() {
        return isOpenPrize;
    }
    
    public void setIsOpenPrize(Boolean isOpenPrize) {
        this.isOpenPrize = isOpenPrize;
    }

    public Boolean getDeleted() {
		return deleted;
	}

	public void setDeleted(Boolean deleted) {
		this.deleted = deleted;
	}

	public void openSwitch(int s) {
		int v = 1 << s;
		switches = switches | v;
	}

	public void closeSwitch(int s) {
		int v = 1 << s;
		v = ~v;
		switches = switches & v;
	}

	public boolean isOpenSwitch(int s) {
		int v = 1 << s;
		int ret = switches & v;
		return ret != 0;
	}
	
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public String getTitle() {
		return title;
	}
	public void setTitle(String title) {
		this.title = title;
	}
	public Integer getStatus() {
		return status;
	}
	public void setStatus(Integer status) {
		this.status = status;
	}
	public Long getCreditsPrice() {
		return creditsPrice;
	}
	public void setCreditsPrice(Long creditsPrice) {
		this.creditsPrice = creditsPrice;
	}
	public Integer getLimitCount() {
		return limitCount;
	}
	public void setLimitCount(Integer limitCount) {
		this.limitCount = limitCount;
	}
	public Integer getLimitScope() {
		return limitScope;
	}
	public void setLimitScope(Integer limitScope) {
		this.limitScope = limitScope;
	}
	public Integer getFreeLimit() {
		return freeLimit;
	}
	public void setFreeLimit(Integer freeLimit) {
		this.freeLimit = freeLimit;
	}
	public Integer getFreeScope() {
		return freeScope;
	}
	public void setFreeScope(Integer freeScope) {
		this.freeScope = freeScope;
	}
	public String getRule() {
		return rule;
	}
	public void setRule(String rule) {
		this.rule = rule;
	}
	public String getBanner() {
		return banner;
	}
	public void setBanner(String banner) {
		this.banner = banner;
	}
	public String getSmallImage() {
		return smallImage;
	}
	public void setSmallImage(String smallImage) {
		this.smallImage = smallImage;
	}
	public String getWhiteImage() {
		return whiteImage;
	}
	public void setWhiteImage(String whiteImage) {
		this.whiteImage = whiteImage;
	}
	public String getLogo() {
		return logo;
	}
	public void setLogo(String logo) {
		this.logo = logo;
	}
	public String getRecommendImage() {
		return recommendImage;
	}
	public void setRecommendImage(String recommendImage) {
		this.recommendImage = recommendImage;
	}
	public Integer getSwitches() {
		return switches;
	}
	public void setSwitches(Integer switches) {
		this.switches = switches;
	}
	public Date getAutoOffDate() {
		return autoOffDate;
	}
	public void setAutoOffDate(Date autoOffDate) {
		this.autoOffDate = autoOffDate;
	}
	public Date getGmtCreate() {
		return gmtCreate;
	}
	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}
	public Date getGmtModified() {
		return gmtModified;
	}
	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public String getLuckNum() {
		return luckNum;
	}

	public void setLuckNum(String luckNum) {
		this.luckNum = luckNum;
	}

    public Long getActivityCategoryId() {
        return activityCategoryId;
    }

    public void setActivityCategoryId(Long activityCategoryId) {
        this.activityCategoryId = activityCategoryId;
    }
}
