package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.domain.dataobject.ActPreStockDO;

import java.util.List;


public interface RemoteActPreStockService {

	public void addAppActPreStock(Long configId, Long prizeId,
								  Long quantity, String name, String relationType, Long appId);
	/**
	 * 新增共享预分配库存
	 * @param configId
	 * @param prizeId
	 * @param quantity
	 * @param name
	 * @param relationType
	 */
	public void addShareActPreStock(Long configId, Long prizeId, Long quantity, String name, String relationType);

	/**
	 * 刷新共享预分配库存
	 * @param prizeId
	 * @param relationType
	 * @param appId
	 * @param quantity
	 * @param name
	 * @return
	 */
	public int refreshActPreStock(Long prizeId, String relationType, Long appId, Long quantity, String name);

	/**
	 * 删除活动，则删除
	 * @param configId
	 * @return
	 */
	public int deleteActStock(Long configId, String relationType);

	/**
	 * 删除活动的奖品
	 * @param configId
	 * @param prizeId
	 * @param relationType
	 * @return
	 */
	public int deleteActPrizeStock(Long configId, Long prizeId, String relationType);

	/**
	 * 删除appId
	 * @param configId
	 * @param prizeId
	 * @param relationType
	 * @param appId
	 * @return
	 * @throws Exception
	 */
	public int deleteActStockAppId(Long prizeId, String relationType, Long appId) ;

	/**
	 * 查询预分配库存
	 * @param prizeId
	 * @param relationType
	 * @param appId
	 * @return
	 */
	public ActPreStockDO findPreStock(Long prizeId, String relationType, Long appId);

	/**
	 * 查询预分配库存,根据配置id
	 * @param configId
	 * @param relationType
	 * @return
	 */
	public List<ActPreStockDO> findPreStock(Long configId, String relationType);
}
