package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.domain.dataobject.DuibaQuestionAnswerOrdersDO;

import java.util.Date;
import java.util.List;

public interface RemoteDuibaQuestionAnswerOrdersService {

	DuibaQuestionAnswerOrdersDO insert(DuibaQuestionAnswerOrdersDO order);

	void updateStatusToConsumeSuccess(Long id);

	DuibaQuestionAnswerOrdersDO find(Long id);

	void updateStatusToConsumeFail(Long id, String error4admin, String error4developer, String error4consumer);
	
	void updateStatusToSuccess(Long id);

	void updateDeveloperBizId(Long questionOrderId, String bizId);

	public Integer countByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId);
	
	public Integer countByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end);
	
	public Integer countFreeByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId);
	
	public Integer countFreeByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end);

	void updateExchangeStatusToFail(Long questionOrderId, String error4admin, String error4developer, String error4consumer);

	void updateMainOrderId(Long questionOrderId, Long mainOrderId, String mainOrderNum);

	int updateExchangeStatusToOverdue(Long questionOrderId, String error4admin, String error4developer, String error4consumer);
	
	int updateExchangeStatusToSucess(Long questionOrderId, String error4admin, String error4developer, String error4consumer);
	
	int updateExchangeStatusToWait(Long questionOrderId, String error4admin, String error4developer, String error4consumer);

	int doTakePrize(Long questionOrderId);

	void rollbackTakePrize(Long questionOrderId);

	List<Long> findOverdueOrder();

	List<DuibaQuestionAnswerOrdersDO> findByIds(List<Long> questionIds);

    /**
     * @param questionOrdersDO
     */
    void updatePrizeInfo(DuibaQuestionAnswerOrdersDO questionOrdersDO);

    /**
     * @param orderId
     * @param rightCount
     */
    void updateScore(Long orderId, Integer rightCount);

    /**
     * @param id
     * @param bizId
     * @return
     */
    DuibaQuestionAnswerOrdersDO findByAppAndDeveloperBizId(Long appId, String bizId); 

    List<DuibaQuestionAnswerOrdersDO> findQuestionOrderLimit50(Long appId, Long activityId);

	int updateLuckPrizeNone(DuibaQuestionAnswerOrdersDO order);
}
