package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.domain.dataobject.DuibaSecondsKillActivityDO;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.service.item.domain.vo.AddActivityVO;

import java.util.List;
import java.util.Map;

public interface RemoteDuibaSecondsKillActivityService {

	public DuibaSecondsKillActivityDO find(Long id);
	
	public String findTagById(Long id);

	public List<AddActivityVO> findAllDuibaSecondKillByAppId(Long appId);

	public List<DuibaSecondsKillActivityDO> findAllByIds(List<Long> ids);


	public List<DuibaSecondsKillActivityDO> findAutoOff();

	public void changeStatus(Long id, Integer status);



	public int updateAutoOffDateNull(Long id);

	public DuibaSecondsKillActivityDO insert(DuibaSecondsKillActivityDO duibaSecondsKillActivityDO);

	public List<DuibaSecondsKillActivityDO> findByPage(Map<String, Object> params);

	public int count();

	public int count(Map<String, Object> params);

	public void deleteById(Long id);

	public void updateSwitches(Long id, Long switches);

	public void update(DuibaSecondsKillActivityDO duibaSecondsKillActivityDO);



	//from DuibaSecondsKillService

	/**
	 * 后台关闭并且下架专题活动
	 */
	public DuibaSecondsKillActivityDO closeAndUnViewDuibaActivity(Long id);

	/**
	 * 添加活动到开发者运营活动,from developer,因为方法名冲突,所以加入_developer后缀
	 */
	public Long addDuibaActivityToDeveloper_developer(Long appId, Long duibaActivityId, String isPreview) throws BusinessException;

	/**
	 * 添加活动到开发者运营活动
	 */
	public Long addDuibaActivityToDeveloper(Long appId, Long duibaActivityId, String isPreview) throws BusinessException;

	//from DuibaSecondsKillActivityService

	/**
	 * 后台创建兑吧秒杀专题-创建权限
	 */
	public void createDuibaSecondKillActivity(DuibaSecondsKillActivityDO duibaSecondsKillActivityDO);

	/**
	 * 后台更新兑吧秒杀专题-更新权限
	 */
	public void updateDuibaSecondKillActivity(DuibaSecondsKillActivityDO duibaSecondsKillActivityDO);

	//from DuibaSecondsKillActivityService in manager and from from DuibaSeckillServiceImpl
	/**
	 * 添加秒杀专题活动的子活动到开发者活动中
	 */
	public void addChildrenActivityToDeveloper(DuibaSecondsKillActivityDO duibaActivity, Long operatingActivityId, Long appId);


	//from AdminDuibaSecondsKillActivityManagerImpl

	public DuibaSecondsKillActivityDO deleteDuibaSecondsKillActivity(Long id);

	public DuibaSecondsKillActivityDO closeDuibaSecondsKillActivity(Long id);

	public void startupDuibaSecondsKillActivity(Long id);

	public DuibaSecondsKillActivityDO closeAndUnViewDuibaSecondsKillActivity(Long id);

	public void addDuibaSecondsKillActivityAppSpecify(Long id, String[] appIds);
}

