/**
 * Project Name:duiba-service-api
 * File Name:RemoteHdtoolDefaultSkinService.java
 * Package Name:cn.com.duiba.service.remoteservice
 * Date:2016年6月2日上午10:49:40
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.service.remoteservice;

import java.util.List;

import cn.com.duiba.service.domain.biz.HdtoolSkinDefaultEntity;
import cn.com.duiba.service.domain.dto.HdtoolSkinDefaultDataDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteHdtoolDefaultSkinService <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年6月2日 上午10:49:40 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteHdtoolDefaultSkinService {

    /**
     * 创建一条默认皮肤模版数据
     * @author zp
     * @param hdtoolSkinDefaultData
     * @since JDK 1.6
     */
    public void createHdtoolDefaultSkin(HdtoolSkinDefaultEntity hdtoolSkinDefaultEntity);
    
    /**
     * 更新一条默认皮肤模版数据
     * @author zp
     * @param hdtoolSkinDefaultData
     * @since JDK 1.6
     */
    public DubboResult<Integer> updateHdtoolDefaultSkin(HdtoolSkinDefaultEntity hdtoolSkinDefaultEntity);
    
    /**
     * 查询默认活动配置
     * @author zp
     * @param templateType
     * @param type
     * @return
     * @since JDK 1.6
     */
    public DubboResult<HdtoolSkinDefaultDataDto> queryHdtoolBaseSkin(String templateType,String type);
    
    /**
     * 查询默认活动配置集
     * @author zp
     * @param templateType
     * @param type
     * @return
     * @since JDK 1.6
     */
    public DubboResult<HdtoolSkinDefaultDataDto> queryHdtoolDefaultConfig(String templateType,String type);
    
    /**
     * 分页查询
     * @author zp
     * @param offset
     * @param max
     * @return
     * @since JDK 1.6
     */
    public DubboResult<List<HdtoolSkinDefaultDataDto>> queryListPagnation(Integer offset,Integer max);
    
    /**
     * 查询总条数
     * @author zp
     * @param offset
     * @param max
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Integer> queryListCount();
}

