package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.domain.dataobject.TurntableOrderDO;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.service.item.domain.dataobject.OperatingActivityDO;

/**
 * 大转盘奖项库存操作
 * @author zp
 *
 * from TurntableStockOperateService
 *
 */
public interface RemoteTurntableService {

	//方法来自TurntableService from manager
	public void saveOrUpdateDuibaTurntableOptions(Long turntableId, Long[] id, String[] type, String[] logo, Long[] itemId, String[] rate, Integer[] limitCount, Integer[] minComein, Integer[] remaining, Integer[] preRemaining, Integer[] facePrice, String[] name) throws BusinessException;

	//方法来自TurntableService from developer
	/**
	 * 保存或修改大转盘抽奖活动选项
	 *
	 * @param turntableId
	 *            大转盘活动ID
	 * @param appId
	 *            AppId
	 * @param id
	 *            奖项ID
	 * @param num
	 *            奖项序号
	 * @param logo
	 *            奖项图标
	 * @param appItemId
	 *            奖项引用兑换项ID
	 * @param rate
	 *            奖项中奖率
	 * @param minComein
	 *            奖项保底人数
	 * @param remaining
	 *            奖项剩余数量
	 * @param facePrice
	 *            奖项面额
	 * @param name
	 *            奖项文案
	 * @return
	 */
	public void saveOrUpdateTurntableOptions(Long turntableId, Long appId, Long[] id, String[] type, String[] logo, Long[] appItemId, String[] rate, Integer[] limitCount, Integer[] minComein, Integer[] remaining, Integer[] preRemaining, Integer[] facePrice, String[] prizeDegree, String[] name) throws BusinessException;

	/**
	 * 删除大转盘活动
	 *
	 * @param id
	 * @param appId
	 */
	public OperatingActivityDO deleteTurntable(Long id, Long appId);

	/**
	 * 来自DevTurntableCtrl.saveTurntable
	 * 把原来的saveOrUpdateTurntable和saveOrUpdateTurntableOptions合并成如下这句,以放在一个事务内
	 *
	 * @throws BusinessException
	 */
	public void saveTurntable(OperatingActivityDO activity, Long appId, Long[] id, String[] type, String[] logo, Long[] appItemId, String[] rate, Integer[] limitCount, Integer[] minComein, Integer[] remaining, Integer[] preRemaining, Integer[] facePrice, String[] prizeDegree, String[] name) throws BusinessException;

	/**
	 * from TurntableService.returnTurntableLotteryStock in credits
	 * @param to
	 */
	public void returnTurntableLotteryStockInner(TurntableOrderDO to) throws BusinessException, StatusException;
}
