package cn.com.duiba.service.domain.dataobject;

import cn.com.duiba.service.domain.BaseDO;

import java.util.Date;

public class AppExceptionLogDO extends BaseDO {

	private static final long serialVersionUID = 8753935244658301147L;

	public static final String ChargeModeMall = "mall";
	public static final String ChargeModeApi = "api";
	public static final String ChargeModeTurntable = "turntable";// 来自大转盘订单
	public static final String ChargeModeSingleLottery = "singlelottery"; //来自单品抽奖
	public static final String ChargeModeManualLottery = "manuallottery";//手工开奖
	public static final String ChargeModeHdtool = "hdtool"; //活动工具
	public static final String ChargeModeGame = "game"; //活动工具
	public static final String ChargeModeQuestion = "question"; //答题活动
	public static final String ChargeModeQuizz = "quizz";//测试题活动
	public static final String ChargeModeNgame = "ngame"; //新游戏
	public static final String ChargeModeGuess = "guess"; //竞猜

	public static final int RelationTypeDefault = 0; // 普通订单
	public static final int RelationTypeActivity = 1; // 专题活动订单
	public static final int RelationTypeSingleLottery = 2; // 单品抽奖
	public static final int RelationTypeTurntable = 3;// 大转盘订单
	public static final int RelationTypeManualLottery = 4;//手动开奖
	public static final int RelationTypeHdtool = 5;//摇一摇
	public static final int RelationTypeHdtool2 = 6;//刮一刮
	public static final int RelationTypeHdtoolTiger = 7;//老虎机
	public static final int RelationTypeHdtoolTurntable = 8;//活动工具幸运转盘
	public static final int RelationTypeGameSanta = 20; //圣诞老人
	public static final int RelationTypeGameMoney = 21; //数钱游戏
	public static final int RelationTypeGameGirl = 22; //女神pk
	public static final int RelationTypeGameJiong = 23; //人在囧途
	public static final int RelationTypeQuestionMoney = 30; //元宵答题
	public static final int RelationTypeQuizz = 41; //测试题
	
	public static final int ConsumerCreditsType = 1;//用户积分扣除接口
	public static final int RelationTypeNgame = 28; //新游戏
	public static final int RelationTypeGuess = 42; //竞猜活动


	private Long id;
	private Long orderId;
	private String orderNum;// 订单号
	private Long appId;
	private Long consumerId;
	private String url;
	private String errorMessage;
	private String respone;
	private Integer devExceptionType;// json,超时
	private Long relationId;// 关联对象id，如果ChargeMode=turntable，则此为大转盘订单id
	private Integer relationType;
	private Integer interfaceType;
	private String title;
	private Date gmtCreate;
	private Date gmtModified;
	private String developerBizId; // 开发者的业务id
	
	public AppExceptionLogDO() {
	}

	public AppExceptionLogDO(Long id) {
		this.id = id;
		this.gmtModified=new Date();
		toBeUpdate = true;
	}

	public AppExceptionLogDO(boolean init4insert) {
		if (init4insert) {
			toBeInsert = true;
			relationType = RelationTypeDefault;
			gmtCreate = new Date();
			gmtModified = gmtCreate;
		}
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getOrderId() {
		return orderId;
	}

	public void setOrderId(Long orderId) {
		this.orderId = orderId;
	}

	public String getOrderNum() {
		return orderNum;
	}

	public void setOrderNum(String orderNum) {
		this.orderNum = orderNum;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Long getConsumerId() {
		return consumerId;
	}

	public void setConsumerId(Long consumerId) {
		this.consumerId = consumerId;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getErrorMessage() {
		return errorMessage;
	}

	public void setErrorMessage(String errorMessage) {
		this.errorMessage = errorMessage;
	}

	public String getRespone() {
		return respone;
	}

	public void setRespone(String respone) {
		if(respone!=null && respone.length()>3000){
			respone = respone.substring(0,3000);
		}
		this.respone = respone;
	}

	public Integer getDevExceptionType() {
		return devExceptionType;
	}

	public void setDevExceptionType(Integer devExceptionType) {
		this.devExceptionType = devExceptionType;
	}

	public Long getRelationId() {
		return relationId;
	}

	public void setRelationId(Long relationId) {
		this.relationId = relationId;
	}

	public Integer getRelationType() {
		return relationType;
	}

	public void setRelationType(Integer relationType) {
		this.relationType = relationType;
	}

	public Integer getInterfaceType() {
		return interfaceType;
	}

	public void setInterfaceType(Integer interfaceType) {
		this.interfaceType = interfaceType;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public String getDeveloperBizId() {
		return developerBizId;
	}

	public void setDeveloperBizId(String developerBizId) {
		this.developerBizId = developerBizId;
	}


}
