package cn.com.duiba.service.domain.dataobject;

import cn.com.duiba.service.domain.BaseDO;

import java.util.Date;

public class SingleLotteryStockManualChangeDO extends BaseDO{
	private static final long serialVersionUID = -3896683486535776950L;

	public static final String TYPE_DUIBA_ITEM = "duiba";
	public static final String TYPE_APP_ITEM = "app";
	public static final String KIND_ADD = "add";
	public static final String KIND_SUB = "sub";
	public static final String OPTION_MAIN = "main";
	public static final String OPTION_INCITE = "incite";

	private Long id;
	private Long relationId;
	private String relationType;
	private String optionType;
	private String changeKind;
	private Long changeQuantity;
	private Long beforeStock;
	private Long afterStock;
	private Date gmtCreate;
	private Date gmtModified;
	
	public SingleLotteryStockManualChangeDO(boolean init4insert) {
		if (init4insert) {
			toBeInsert = true;
			gmtCreate = new Date();
			gmtModified = new Date();
		}
	}

	public SingleLotteryStockManualChangeDO() {
	}

	public SingleLotteryStockManualChangeDO(Long id) {
		this.id = id;
		this.gmtModified = new Date();
		toBeUpdate = true;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getRelationId() {
		return relationId;
	}

	public void setRelationId(Long relationId) {
		this.relationId = relationId;
	}

	public String getRelationType() {
		return relationType;
	}

	public void setRelationType(String relationType) {
		this.relationType = relationType;
	}

	public String getChangeKind() {
		return changeKind;
	}

	public void setChangeKind(String changeKind) {
		this.changeKind = changeKind;
	}

	public Long getChangeQuantity() {
		return changeQuantity;
	}

	public void setChangeQuantity(Long changeQuantity) {
		this.changeQuantity = changeQuantity;
	}

	public Long getBeforeStock() {
		return beforeStock;
	}

	public void setBeforeStock(Long beforeStock) {
		this.beforeStock = beforeStock;
	}

	public Long getAfterStock() {
		return afterStock;
	}

	public void setAfterStock(Long afterStock) {
		this.afterStock = afterStock;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public String getOptionType() {
		return optionType;
	}

	public void setOptionType(String optionType) {
		this.optionType = optionType;
	}
	
	
}
