package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.domain.dataobject.ActPreStockDO;
import cn.com.duiba.service.exception.BusinessException;

public interface RemoteActStockConsumerService {

	//from ActStockConsumerService in credits
	
	/*
	 * 消费活动预分配库存
	 * @param hdPreStockDO
	 * @param bizId
	 * @param bizSource
	 */
	public void consumeActStock(Long prizeId, String bizId, String bizSource, Long appId) throws BusinessException;
	 
	/*
	 * 还活动预分配库存
	 * @param bizId
	 * @param bizSource
	 */
	public void paybackActStock(String bizId, String bizSource) throws BusinessException;
	
	/*
	 * 查询活动可用的预分配库存
	 * @param relationPrizeId
	 * @param relationType
	 * @param appId
	 * @return
	 */
	public ActPreStockDO findActValidStock(Long relationPrizeId, String relationType, Long appId);
	
}
