package cn.com.duiba.service.domain.dataobject;

import cn.com.duiba.service.domain.BaseDO;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class ActPreStockDO extends BaseDO{
	private static final long serialVersionUID = -8795345646267993316L;
	
	public static final String ACTION_PAY = "pay";
	public static final String ACTION_BACK = "back";
	public static final String BIZ_SOURCE_SINGLELOTTERY= "singlelottery";
	public static final String BIZ_SOURCE_HDTOOL = "hdtool";

	private Long id;

    private Long relationConfigId;

    private Long relationPrizeId;

    private String relationType;

    private String prizeName;

    private Long prizeQuantity;

    private Long appId;

    private Integer deleted;

    private Date gmtCreate;

    private Date gmtModified;
    
    public ActPreStockDO(boolean init4insert) {
		if (init4insert) {
			toBeInsert = true;
			gmtCreate = new Date();
			gmtModified = new Date();
		}
	}

	public ActPreStockDO() {
	}

	public ActPreStockDO(Long id) {
		this.id = id;
		this.gmtModified = new Date();
		toBeUpdate = true;
	}
	
	public static class PrizeSure implements Serializable{
		private static final long serialVersionUID = 3987636045723365357L;
		private Long id;
		private Long value;
		public Long getId() {
			return id;
		}
		public void setId(Long id) {
			this.id = id;
		}
		public Long getValue() {
			return value;
		}
		public void setValue(Long value) {
			this.value = value;
		}
		
		
	}
	
	public static class JsonSures implements Serializable{
		private static final long serialVersionUID = 6581939349380671119L;
		private Long id;
		private String name;
		private List<PrizeSure> admeasure;
		
		public Long getId() {
			return id;
		}
		public void setId(Long id) {
			this.id = id;
		}
		public String getName() {
			return name;
		}
		public void setName(String name) {
			this.name = name;
		}
		public List<PrizeSure> getAdmeasure() {
			return admeasure;
		}
		public void setAdmeasure(List<PrizeSure> admeasure) {
			this.admeasure = admeasure;
		}
		
	}
	
	public static class Prizes implements Serializable{
		private static final long serialVersionUID = 9127156916779093763L;
		private Long id;
		private String name;
		private Long count;
		
		
		public Long getId() {
			return id;
		}
		public void setId(Long id) {
			this.id = id;
		}
		public String getName() {
			return name;
		}
		public void setName(String name) {
			this.name = name;
		}
		public Long getCount() {
			return count;
		}
		public void setCount(Long count) {
			this.count = count;
		}
	}
	
	public static class JsonStock implements Serializable{
		private static final long serialVersionUID = -3633001224701536853L;
		private List<JsonSures> admeasures;
		private List<Prizes> prizes;
		private String title;
		public List<JsonSures> getAdmeasures() {
			return admeasures;
		}
		public void setAdmeasures(List<JsonSures> admeasures) {
			this.admeasures = admeasures;
		}
		public List<Prizes> getPrizes() {
			return prizes;
		}
		public void setPrizes(List<Prizes> prizes) {
			this.prizes = prizes;
		}
		public String getTitle() {
			return title;
		}
		public void setTitle(String title) {
			this.title = title;
		}
		
	}

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getRelationConfigId() {
        return relationConfigId;
    }

    public void setRelationConfigId(Long relationConfigId) {
        this.relationConfigId = relationConfigId;
    }

    public Long getRelationPrizeId() {
        return relationPrizeId;
    }

    public void setRelationPrizeId(Long relationPrizeId) {
        this.relationPrizeId = relationPrizeId;
    }

    public String getRelationType() {
        return relationType;
    }

    public void setRelationType(String relationType) {
        this.relationType = relationType == null ? null : relationType.trim();
    }

    public String getPrizeName() {
        return prizeName;
    }

    public void setPrizeName(String prizeName) {
        this.prizeName = prizeName == null ? null : prizeName.trim();
    }

    public Long getPrizeQuantity() {
        return prizeQuantity;
    }

    public void setPrizeQuantity(Long prizeQuantity) {
        this.prizeQuantity = prizeQuantity;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
   
}
