package cn.com.duiba.service.item.domain.dataobject;

import cn.com.duiba.service.domain.BaseDO;

import java.util.Date;

/**
 * app兑换项自定义分类
 * 
 * @author houwen
 */
public class AppItemClassifyDO extends BaseDO {
	private static final long serialVersionUID = 2112131235L;

	private Long id;

	private Long appId;

	private String name;

	private Boolean deleted;

	private Date gmtCreate;

	private Date gmtModified;

	private Integer appItemNum;
	
	private String image;
	
	private String classifyImage;//分类列表表头图片
	
	private Boolean classifyImageSwitch;//分类列表表头图片显示开关

	public AppItemClassifyDO() {

	}

	public AppItemClassifyDO(boolean init4insert) {
		if (init4insert) {
			deleted=false;
			gmtCreate = new Date();
			gmtModified = gmtCreate;
			toBeInsert = true;
		}
	}

	public AppItemClassifyDO(Long id) {
		this.id = id;
		this.gmtModified = new Date();
		toBeUpdate = true;
	}

	public Integer getAppItemNum() {
		return appItemNum;
	}

	public void setAppItemNum(Integer appItemNum) {
		this.appItemNum = appItemNum;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Boolean getDeleted() {
		return deleted;
	}

	public void setDeleted(Boolean deleted) {
		this.deleted = deleted;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public String getImage() {
		return image;
	}

	public void setImage(String image) {
		this.image = image;
	}

	public String getClassifyImage() {
		return classifyImage;
	}

	public void setClassifyImage(String classifyImage) {
		this.classifyImage = classifyImage;
	}

	public Boolean getClassifyImageSwitch() {
		return classifyImageSwitch;
	}

	public void setClassifyImageSwitch(Boolean classifyImageSwitch) {
		this.classifyImageSwitch = classifyImageSwitch;
	}
	
}
