package cn.com.duiba.service.item.remoteservice;

import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.service.item.domain.dataobject.DuibaActivityDO;
import cn.com.duiba.service.item.domain.dataobject.DuibaSingleLotteryDO;
import cn.com.duiba.service.item.domain.dataobject.SingleLotteryAppSpecifyDO;
import cn.com.duiba.service.item.domain.vo.ActivityExtraInfoVO;
import cn.com.duiba.service.item.domain.vo.AddActivityVO;

import java.util.List;
import java.util.Map;

/**
 * 兑吧单品抽奖业务DAO
 */
public interface RemoteDuibaSingleLotteryService {

	//DuibaSingleLotterySimpleDAO

	/**
	 * 查询一天内，需要定时下架的单品抽奖
	 * @return
	 */
	public List<DuibaSingleLotteryDO> findAutoOff();

	/**
	 * 根据ID查询
	 */
	public DuibaSingleLotteryDO find(Long id);

	/**
	 * 单品抽奖分页列表
	 */
	public List<DuibaSingleLotteryDO> findSingleLotteryPage(Map<String, Object> queryMap);

	/**
	 * 单品抽奖分页条数
	 */
	public List<DuibaSingleLotteryDO> findSingleLottery(Map<String, Object> queryMap);

	/**
	 * 获取管理员端单品抽奖活动数目
	 */
	//Start chaijiangang,管理员后台活动管理页面增加筛选条件,2016/03/30
	/*
	public Long findSingleLotteryPageCount() {
		return this.getSqlSession().selectOne(getStamentNameSpace("findSingleLotteryPageCount"));
	}*/
	public Long findSingleLotteryPageCount(Map<String, Object> queryMap);
	//End chaijiangang,管理员后台活动管理页面增加筛选条件,2016/03/30

	/**
	 * 获取可用兑吧单品抽奖
	 */
	public List<AddActivityVO> findAllDuibaSingleLottery(Long appId);

	/**
	 * 根据id集合查询
	 */
	public List<DuibaSingleLotteryDO> findAllByIds(List<Long> ids);

	/**
	 * 模糊查询统计
	 */
	public Long getCountDuibaSingleLottery(Map<String, Object> queryMap);

	/**
	 * 根据兑吧单品和APP查询定向关系
	 */
	public SingleLotteryAppSpecifyDO findSpecifyByDuibaSingleLotteryAndApp(Long duibaSingleLotteryId, Long appId);

	/**
	 * 根据duibaSingleLotteryId查询List
	 */
	public List<SingleLotteryAppSpecifyDO> findAllSpecifyByDuibaSingleLottery(Long duibaSingleLotteryId);

	/**
	 * 通过定向ID查询定向关系
	 */
	public SingleLotteryAppSpecifyDO findSpecifyById(Long id);

	/**
	 * 查询是否被兑吧单品使用
	 * @param itemId
	 * @return
	 */
	public List<Long> findHasUserdSingleIds(Long itemId);

	/**
	 *
	 * @param id
	 * @return
	 */
	public ActivityExtraInfoVO findExtraInfoById(Long id);


	//DuibaSingleLotteryTextChangeDAO


	public int updateAutoOffDate(Long id);

	/**
	 * 新增兑吧单品抽奖
	 */
	public DuibaSingleLotteryDO insert(DuibaSingleLotteryDO duibaSingleLotteryDO);

	/**
	 * 根据ID修改
	 */
	public int update(DuibaSingleLotteryDO duibaSingleLotteryDO);

	/**
	 * 主奖品减数量
	 */
	public int reduceMainItemRemaining(Long id);

	/**
	 * 主奖品添加数量
	 */
	public int addMainItemRemaining(Long id);

	/**
	 * 小奖品减数量
	 */
	public int reduceInciteItemRemaining(Long id);

	/**
	 * 小奖品加数量
	 */
	public int addInciteItemRemaining(Long id);

	/**
	 * 后台编辑更新
	 */
	public int updateForAdminEdit(DuibaSingleLotteryDO duibaSingleLotteryDO);

	/**
	 * 减去定向APP数量
	 */
	public int reduceSpecifyAppRemaining(Long duibaSingleLotteryId, Long appId);

	/**
	 * 添加定向APP数量
	 */
	public int addSpecifyAppRemaining(Long duibaSingleLotteryId, Long appId);

	/**
	 * 加APP定向订单数
	 */
	public int addSpecifyOrderCount(Long duibaSingleLotteryId, Long appId);

	/**
	 * 删除定向
	 */
	public int deleteSpecify(Long id);

	/**
	 * 添加APP定向关系
	 */
	public void insertAppSpecify(SingleLotteryAppSpecifyDO singleLotteryAppSpecifyDO);

	/**
	 * 修改定向数量
	 */
	public int updateSpecifyRemaining(Long id, Integer remaining);


	//DuibaSingleLotteryStatusChangeDAOImpl


	/**
	 * 增加主奖品的数量
	 */
	public int addMainItemRemainingById(Long id, Integer addMainItemRemaining);

	/**
	 * 减少主奖品的数量
	 */
	public int subMainItemRemainingById(Long id, Integer subMainItemRemaining);

	/**
	 * 增加鼓励奖数量
	 */
	public int addInciteItemRemainingById(Long id, Integer addInciteItemRemaining);

	/**
	 * 减少鼓励奖数量
	 */
	public int subInciteItemRemainingById(Long id, Integer subInciteItemRemaining);

	//from AdminDuibaSingleLotteryManager from manager

	/**
	 * 更新单品抽奖的主奖项库存
	 */
	public void updateMainItemRemainingByEdit(Long duibaSingleLotteryId, Integer preRemaining, Integer requiredRemaining) throws BusinessException;

	/**
	 * 更新单品抽奖的鼓励奖的库存
	 */
	public void updateInciteItemRemainingByEdit(Long duibaSingleLotteryId, Integer preRemaining, Integer requiredRemaining) throws BusinessException;

	/**
	 * 添加专题活动的子活动到开发者活动中
	 */
	public void addChildrenActivityToDeveloper(DuibaActivityDO duibaActivity, Long operatingActivityId, Long appId);

	/**
	 * 关闭并且未发布/后台关闭并且下架单品抽奖
	 */
	public DuibaSingleLotteryDO closeAndUnViewSingleLottery(Long id);

	/**
	 * 把兑吧单品抽奖添加到开发者
	 */
	public Long addSingleLotteryToDeveloper(Long appId, Long duibaSingleLotteryId, String isPreview) throws BusinessException;

	/**
	 * 关闭
	 */
	public DuibaSingleLotteryDO closeDuibaSingleLotteryNoTransaction(Long id);

	/**
	 * 删除
	 * @return
	 */
	public DuibaSingleLotteryDO deleteSingleLottery(Long id);

	/**
	 * 更新单品抽奖
	 */
	public void updateSingleLottery(DuibaSingleLotteryDO duibaSingleLottery);

	/**
	 * 开启
	 */
	public void startupSingleLottery(Long id);

	/**
	 * 来自AdminDuibaSingleLotteryCtrl.update
	 * 更新单品抽奖
	 */
	public void updateSingleLotteryAndItemRemainingByEdit(DuibaSingleLotteryDO duibaSingleLottery, Integer preMainItemRemaining, Integer mainItemRemaining, Integer preInciteItemRemaining, Integer inciteItemRemaining) throws BusinessException;

}
