package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.domain.dataobject.AppScheduledTasksDO;

import java.util.Date;
import java.util.List;

public interface RemoteAppScheduledTasksService {

	/**
	 * 删除
	 */
	public void delete(Long id);

	/**
	 * 根据兑吧任务获取所有app任务
	 */
	public List<AppScheduledTasksDO> findAllByDuibaTasksId(Long duibaScheduledTaskId);
	
	/**
	 * 根据时间获取该时间以前所有待执行的app计划任务
	 */
	public List<AppScheduledTasksDO> findAppTaskByExcuteTime(Date excuteTime);
	
	/**
	 * 根据兑吧任务ID和appIds获取
	 */
	public List<AppScheduledTasksDO> findAllByDuibaTasksIdAndAppIds(Long duibaScheduledTaskId, List<Long> appIds);
	
	/**
	 * 根据appId获取所有兑吧推送的待执行的计划任务
	 */
	public List<AppScheduledTasksDO> findAllDuibaTasksByAppIdAndTag(Long appId, Boolean duiba);
	
	/**
	 * 根据sourceId和sourceType批量删除
	 */
	public void deleteBySourceIdAndSourceType(Long sourceId, String sourceType);
	
	public void insert(AppScheduledTasksDO appScheduledTasksDO);

	public AppScheduledTasksDO find(Long id);
	
	public void update(AppScheduledTasksDO appScheduledTasksDO);

	//from AppScheduledTasksService in manager

	/**
	 * 根据时间获取待执行apps，循环执行
	 */
	public void excuteAppScheduledTasks(Date now);

	/**
	 * 根据兑吧任务id获取待执行apps，循环执行
	 */
	public void excuteRightnow(Long duibaScheduledTasksId);
}
