package cn.com.duiba.service.remoteservice;

import cn.com.duiba.activity.center.api.dto.quizz.AddActivityDto;
import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzDto;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.service.item.domain.vo.AddActivityVO;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;

public interface RemoteDuibaQuizzService {

	public DubboResult<DuibaQuizzDto> find(Long id);

	public DubboResult<List<DuibaQuizzDto>> findByPage(Integer offset, Integer max);

	public DubboResult<Long> findPageCount(Map<String, Object> paramMap);

	DubboResult<List<DuibaQuizzDto>> findByPage(Map<String, Object> paramMap);

	public DubboResult<Integer> updateStatus(Long id, int status);

	public DubboResult<Integer> delete(Long id);
	public DubboResult<DuibaQuizzDto> insert(DuibaQuizzDto DuibaQuizzDto);
	public DubboResult<Integer> updateInfoForm(DuibaQuizzDto DuibaQuizzDto);
	public DubboResult<Integer> updateAutoOffDateNull(Long id);

	public void updateSwitches(Long id, Long switches);

	public DubboResult<List<DuibaQuizzDto>> findAutoOff();

	public DubboResult<List<DuibaQuizzDto>> findAllByIds(List<Long> ids);

	public DubboResult<List<AddActivityDto>> findAllQuizz();

	public void update(DuibaQuizzDto DuibaQuizzDto);

	//from DuibaQuizzServiceImpl

	public DubboResult<Long> addDuibaQuizzToDeveloper(Long appId, Long duibaQuizzId) throws BusinessException;

	/**
	 * 关闭并可见
	 *
	 */
	public void updateStatusCloseShow(DuibaQuizzDto quizz);


	/**
	 * from DuibaQuizzCtrl
	 * @param quizzId
	 * @param status
	 */
	public void updateBannerAndAppItem(Long quizzId, Integer status);

	//from AdminQuizzManagerImpl in manager
	public void addDuibaQuizzAppSpecify(Long id, String[] appIds);
}
