package cn.com.duiba.service.item.domain.dataobject;

import cn.com.duiba.service.domain.BaseDO;

import java.util.Date;

/**
 * 兑吧大转盘活动
 * @author houwen
 */
public class DuibaTurntableDO extends BaseDO{
	private static final long serialVersionUID = 6373381601632636008L;
	
	public static final int SWITCHES_DIRECT = 0; // 定向发放
	public static final Integer SWITCHES_DEV_BLACKLIST = 1; // 黑名单商品
	public static final Integer SWITCHES_FREE_RULE = 2; // 免费次数使用的活动规则
	
	public static final int STATUS_NOCOMPLETE = 0;//数据不完整
	public static final int STATUS_UNPUBLISH = 1; //开启且可见
	public static final int STATUS_STARTUP = 2; //关闭且可见
	public static final int STATUS_SHUTDOWN = 3; //关闭不可见
	
	public static final String LimitTypeForever = "forever"; //永久限制
	public static final String LimitTypeEveryday = "everyday"; //每日限制

	private Long id;
	private String title; // 标题
	private Integer creditsPrice;// 扣费金额
	private Integer limitCount;// 日抽奖限制次数
	private String limitScope;//限制类型
	private Integer freeLimit;// 日免费抽奖次数
	private String rule;// 活动规则
	private String explainText;// 活动说明
	private String image;// 活动主题图
	private String logo;// 图标
	private String smallImage;// 缩略图
	private String whiteImage;// 白底缩略图
	private String bannerImage;// 首页默认banner图
	private Integer switches; // 定向发放开关
	private Integer status;// 数据状态
	private Boolean deleted;// 是否删除
	private String subtitle;//说明文字
	private Date gmtCreate;
	private Date gmtModified;
	private String rateIntroduction;	// 概率说明
	private Date autoOffDate; //定时自动下架日期
	private String recommendImage; // 推荐位横幅图
	private String freeRule;

	public DuibaTurntableDO(){
		
	}

	public DuibaTurntableDO(boolean insert) {
		if (insert) {
			toBeInsert=true;
			this.status = 0;
			this.switches = 0;
			this.deleted = false;
			this.gmtCreate = new Date();
			this.gmtModified = gmtCreate;
		}
	}
	
	public DuibaTurntableDO(Long id){
		toBeUpdate=true;
		this.id = id;
		this.gmtModified = new Date();
	}

	public void openSwitch(int s) {
		int v = 1 << s;
		switches = switches | v;
	}

	public void closeSwitch(int s) {
		int v = 1 << s;
		v = ~v;
		switches = switches & v;
	}

	public boolean isOpenSwitch(int s) {
		int v = 1 << s;
		int ret = switches & v;
		return ret != 0;
	}

	public String getRateIntroduction() {
		return rateIntroduction;
	}

	public void setRateIntroduction(String rateIntroduction) {
		this.rateIntroduction = rateIntroduction;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}
	
	public String getSubtitle() {
		return subtitle;
	}

	public void setSubtitle(String subtitle) {
		this.subtitle = subtitle;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Integer getCreditsPrice() {
		return creditsPrice;
	}

	public void setCreditsPrice(Integer creditsPrice) {
		this.creditsPrice = creditsPrice;
	}

	public Integer getLimitCount() {
		return limitCount;
	}

	public void setLimitCount(Integer limitCount) {
		this.limitCount = limitCount;
	}

	public Integer getFreeLimit() {
		return freeLimit;
	}

	public void setFreeLimit(Integer freeLimit) {
		this.freeLimit = freeLimit;
	}

	public String getRule() {
		return rule;
	}

	public void setRule(String rule) {
		this.rule = rule;
	}

	public String getExplainText() {
		return explainText;
	}

	public void setExplainText(String explainText) {
		this.explainText = explainText;
	}

	public String getImage() {
		return image;
	}

	public void setImage(String image) {
		this.image = image;
	}

	public String getLogo() {
		return logo;
	}

	public void setLogo(String logo) {
		this.logo = logo;
	}

	public String getSmallImage() {
		return smallImage;
	}

	public void setSmallImage(String smallImage) {
		this.smallImage = smallImage;
	}

	public String getBannerImage() {
		return bannerImage;
	}

	public void setBannerImage(String bannerImage) {
		this.bannerImage = bannerImage;
	}

	public Integer getSwitches() {
		return switches;
	}

	public void setSwitches(Integer switches) {
		this.switches = switches;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public Boolean getDeleted() {
		return deleted;
	}

	public void setDeleted(Boolean deleted) {
		this.deleted = deleted;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public String getLimitScope() {
		return limitScope;
	}

	public void setLimitScope(String limitScope) {
		this.limitScope = limitScope;
	}

	public Date getAutoOffDate() {
		return autoOffDate;
	}

	public void setAutoOffDate(Date autoOffDate) {
		this.autoOffDate = autoOffDate;
	}

    public String getWhiteImage() {
		return whiteImage;
	}

	public void setWhiteImage(String whiteImage) {
		this.whiteImage = whiteImage;
	}

	public String getRecommendImage() {
		return recommendImage;
	}

	public void setRecommendImage(String recommendImage) {
		this.recommendImage = recommendImage;
	}
	
	public String getFreeRule() {
		return freeRule;
	}

	public void setFreeRule(String freeRule) {
		this.freeRule = freeRule;
	}
}
