package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.domain.dataobject.DuibaScheduledTasksDO;
import cn.com.duiba.service.exception.BusinessException;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 兑吧计划任务dao
 */
public interface RemoteDuibaScheduledTasksService {

	/**
	 * 根据时间获取该时间以前的所有兑吧待执行任务
	 */
	public List<DuibaScheduledTasksDO> findAllByExcuteTime(Date excuteTime);

	/**
	 * 获取管理员后台分页
	 */
	public List<DuibaScheduledTasksDO> findPage(Map<String, Object> queryMap);

	/**
	 * 分页展示数目
	 */
	public Long findPageCount();
	
	/**
	 * 根据ids获取
	 */
	public List<DuibaScheduledTasksDO> findAllByIds(List<Long> ids);
	
	public int updateExcuteStatus(Long id, Integer excuteStatus);
	
	public DuibaScheduledTasksDO find(Long id);


	//from DuibaScheduledTasksService

	/**
	 * 管理员后台开启计划任务
	 */
	public void openDuibaTask(Long id) throws BusinessException;

	/**
	 * 更新或者更新并推送
	 */
	public void updateOrUpdateAndPush(DuibaScheduledTasksDO d4u, boolean ifPush, Long operatorId);

	/**
	 * 兑吧取消计划任务
	 */
	public void cancel(Long id) throws BusinessException;

	public void insert(DuibaScheduledTasksDO duibaScheduledTasksDO, Long operatorId);

	/**
	 * 管理员后台删除
	 */
	public void delete(Long scheduledTasksId, Long operatorId) throws BusinessException;
	
}
