package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.domain.dataobject.DuibaSeckillDO;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.service.item.domain.vo.AddActivityVO;

import java.util.List;
import java.util.Map;

public interface RemoteDuibaSeckillService {
	public DuibaSeckillDO insert(DuibaSeckillDO duibaSeckillDO);
	
	public List<DuibaSeckillDO> findByPage(Map<String, Object> queryMap);
	
	public Long findPageCount();
	
	public Long findPageCount(Map<String, Object> queryMap);
	
	public DuibaSeckillDO find(Long id);
	public List<DuibaSeckillDO> findEffective();
	public int updateStatus(Long id, int status);
	public int delete(Long id);
	public int updateAutoOffDateNull(Long id);
	public int updateInfoForm(DuibaSeckillDO duibaSeckillDO);
	
	public void updateSwitches(Long id, Long switches);
	
	/**
	 * 查询秒杀活动列表.<br>
	 * 【查询参数】
	 * <ol>
	 * <li>offset:查询的开始位置处</li>
	 * <li>max:偏移量</li>
	 * <li>activityName:title名称(支持模糊查询)</li>
	 * <li>activityId:秒杀活动ID</li>
	 * </ol>
	 *
	 * @param queryMap 查询参数
	 * @param List<DuibaSeckillDO> 秒杀活动概要信息
	 */
	public List<DuibaSeckillDO> findByMap(Map<String, Object> paramMap);
	
	public List<DuibaSeckillDO> findAllByIds(List<Long> ids);

	public List<AddActivityVO> findAllSeckill(Long appId);
	
	/**
	 *更新 
	 */
	public void update(DuibaSeckillDO DO);

	//from DuibaSeckillServiceImpl

	//from credits
	public Long addDuibaSeckillToDeveloper(Long appId, Long duibaSeckillId, String isPreview) throws BusinessException;

	//from developer/manager 名字重复,所以加入_backend后缀
	public Long addDuibaSeckillToDeveloper_backend(Long appId, Long duibaSeckillId, String isPreview) throws BusinessException;

	public void updateBannerAndAppItem(Long seckillId, Integer status);

}
