package cn.com.duiba.service.remoteservice;

import java.util.List;
import java.util.Map;

import cn.com.duiba.activity.center.api.dto.quizz.AddActivityDto;
import cn.com.duiba.activity.center.api.dto.seconds_kill.DuibaSecondsKillActivityDto;
import cn.com.duiba.service.exception.BusinessException;

public interface RemoteDuibaSecondsKillActivityService {

	public DuibaSecondsKillActivityDto find(Long id);

	public List<AddActivityDto> findAllDuibaSecondKillByAppId(Long appId);

	public List<DuibaSecondsKillActivityDto> findAllByIds(List<Long> ids);


	public List<DuibaSecondsKillActivityDto> findAutoOff();

	public void changeStatus(Long id, Integer status);



	public int updateAutoOffDateNull(Long id);

	public DuibaSecondsKillActivityDto insert(DuibaSecondsKillActivityDto duibaSecondsKillActivityDO);

	public List<DuibaSecondsKillActivityDto> findByPage(Map<String, Object> params);

	public int count();

	public int count(Map<String, Object> params);

	public void deleteById(Long id);

	public void updateSwitches(Long id, Long switches);

	public void update(DuibaSecondsKillActivityDto duibaSecondsKillActivityDO);



	//from DuibaSecondsKillService

	/**
	 * 后台关闭并且下架专题活动
	 */
	public DuibaSecondsKillActivityDto closeAndUnViewDuibaActivity(Long id);

	/**
	 * 添加活动到开发者运营活动,from developer,因为方法名冲突,所以加入_developer后缀
	 */
	public Long addDuibaActivityToDeveloper_developer(Long appId, Long duibaActivityId, String isPreview) throws BusinessException;

	/**
	 * 添加活动到开发者运营活动
	 */
	public Long addDuibaActivityToDeveloper(Long appId, Long duibaActivityId, String isPreview) throws BusinessException;

	//from DuibaSecondsKillActivityService

	/**
	 * 后台创建兑吧秒杀专题-创建权限
	 */
	public void createDuibaSecondKillActivity(DuibaSecondsKillActivityDto duibaSecondsKillActivityDO);

	/**
	 * 后台更新兑吧秒杀专题-更新权限
	 */
	public void updateDuibaSecondKillActivity(DuibaSecondsKillActivityDto duibaSecondsKillActivityDO);

	//from DuibaSecondsKillActivityService in manager and from from DuibaSeckillServiceImpl
	/**
	 * 添加秒杀专题活动的子活动到开发者活动中
	 */
	public void addChildrenActivityToDeveloper(DuibaSecondsKillActivityDto duibaActivity, Long operatingActivityId, Long appId);


	//from AdminDuibaSecondsKillActivityManagerImpl

	public DuibaSecondsKillActivityDto deleteDuibaSecondsKillActivity(Long id);

	public DuibaSecondsKillActivityDto closeDuibaSecondsKillActivity(Long id);

	public void startupDuibaSecondsKillActivity(Long id);

	public DuibaSecondsKillActivityDto closeAndUnViewDuibaSecondsKillActivity(Long id);

	public void addDuibaSecondsKillActivityAppSpecify(Long id, String[] appIds);
}

