package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.queryparams.AdminPageQueryEntity;
import cn.com.duiba.service.domain.vo.ExchangeStockWarnVO;
import cn.com.duiba.service.domain.vo.ItemClassifyItemCountVO;
import cn.com.duiba.service.domain.vo.StockWarnEmailVO;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.activity.center.api.dto.singlelottery.DuibaSingleLotteryDto;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Created by wenqi.huang on 16/4/26.
 */
public interface RemoteItemService {

    //ItemActivityDAO
    /**
     * 根据类型查找可以给兑吧活动工具使用的items
     */
    public List<ItemDO> findAllByType4DSL(String type);

    /**
     * 根据sourceRelation和sourceType进行查询
     */
    public ItemDO findBySourceRelationIdAndSourceType(Long sourceRelationId, Integer sourceType);

    /**
     * 用于兑吧大转盘和活动工具
     */
    public List<ItemDO> findByInTypes(List<String> types);

    /**
     * 用于获取app自有单品抽奖的可选兑吧兑换项
     */
    public List<ItemDO> findAllByIds4ASL(List<Long> ids);

    /**
     * 获取所有能添加到专题活动中的兑吧兑换项
     */
    public List<ItemDO> findAllActivityItemAndEnable(Boolean enable);

    /**
     * 获取给活动用的items
     */
    public List<ItemDO> findAllByNameAndType4Lottery(String name, String type);

    /**
     * 获取给活动用的items+加钱购
     */
    public List<ItemDO> findAllByNameAndType4LotteryAmb(String name, String type);

    /**
     * 获取可以展示在秒杀专题中的兑换项
     */
    public List<ItemDO> findAllForDuibaSecondsKill();


    //ItemAdminClassifyDAO

    /**
     * 根据分类ids进行in查询
     */
    public List<ItemDO> findAllByClassify(List<Long> classifyIds);

    /**
     * 用于获取分类和兑换项数目的一个map
     */
    public List<ItemClassifyItemCountVO> findItemClassifyCountMap(List<Long> icIds);

    //ItemAdminDAO

    /**
     * 用于优惠券扫描下架
     */
    public List<ItemDO> findBatchScan();

    /**
     * 查询自动推荐的商品，用于扫描下架
     */
    public List<ItemDO> findAutoRecommend(Boolean isAutoRecommend);

    /**
     * 系统推荐的兑换项 + 关联的兑换项（可能包含不是自动推荐的兑换项） 二者互斥关系
     */
    public List<Long> findAutoRecommendAndTagsItems(Long tagsId);

    /**
     * 查询推荐中的兑换项，管理员后台使用
     */
    public List<ItemDO> findRecommandItems(String itemName);

    /**
     * 查询推荐中的兑换项数量，管理员后台使用
     */
    public Long findRecommandItemsCount(String itemName);

    /**
     * 查询所有管理员后台所有启用状态的优惠券，按id倒序
     */
    public List<ItemDO> findAllEnableCoupon();

    /**
     * 获取库存迁移目标Item列表
     */
    public List<ItemDO> findAllTargetItemList(String type, Boolean deleted, Integer subType);

    /**
     * 管理员后台分页查询item列表(使用管理员设置的名称查询)
     */
    public List<ItemDO> findItemByCondAndIdsPage(AdminPageQueryEntity queryEntity);

    /**
     * 管理员后台分页查询item列表总数(使用管理员设置的名称查询)
     */
    public Integer findItemByCondAndIdsPageCount(AdminPageQueryEntity queryEntity);

    /**
     * 管理员后台分页查询item列表
     */
    public List<ItemDO> findAdminItemPage(AdminPageQueryEntity queryEntity);

    /**
     * 管理员后台分页查询item列表总数
     */
    public Integer findAdminItemPageCount(AdminPageQueryEntity queryEntity);
    public List<Map<String, Object>> findAllSupplementItemById(Map<String, Object> queryMap);

    //ItemAppSidebarDAO

    /**
     * 开发者后台侧边栏展示 上新列表中的兑换项 取20个
     */
    public List<ItemDO> findAllNewItem();

    //ItemConsumerDAO
    /**
     * 手机端兑换项列表
     */
    public List<ItemDO> findHomeItem(List<Long> ids);


    //ItemDuibaRepoDAO
    /**
     * 获取所有的黑名单兑换项
     */
    public List<ItemDO> findAllBlacklistItem();

    /**
     * 查询新的兑换项的数目，用于红点
     */
    public Integer getNewItemsNum(Date newItemTime);

    /**
     * 开发者后台兑吧待选库的查询分页
     */
    public List<ItemDO> findDuibaItemChoose(Map<String, Object> paramMap);

    /**
     * 开发者后台兑吧待选库的查询总数
     */
    public Long findDuibaItemChooseCount(Map<String, Object> paramMap);

    /**
     * 开发者后台兑吧待选库的查询免费分页
     */
    public List<ItemDO> findDuibaItemChooseFree(Integer offset, Integer max, String selectType, Set<Long> idsSet, String itemName);

    /**
     * 开发者后台兑吧待选库的查询免费总数
     */
    public Long findDuibaItemChooseCountFree(Integer offset, Integer max, String selectType, Set<Long> idsSet, String itemName);

    /**
     * 开发者后台兑吧待选库的查询收费分页
     */
    public List<ItemDO> findDuibaItemChooseCharge(Integer offset, Integer max,
                                                  String selectType, Set<Long> idsSet, String itemName);

    /**
     * 开发者后台兑吧待选库的查询收费总数
     */
    public Long findDuibaItemChooseCountCharge(Integer offset, Integer max,
                                               String selectType, Set<Long> idsSet, String itemName);


    //ItemSimpleDAO

    /**
     * 查询一天内定时下架的兑换项（优惠券，实物）
     */
    public List<ItemDO> findAutoOffItem();

    /**
     * 根据id查询
     */
    public ItemDO find(Long id);

    /**
     * 根据ids in 查询
     */
    public List<ItemDO> findAllByIds(List<Long> ids);

    /**
     * 根据ids和idsStr查询，返回的顺序是idsStr
     */
    public List<ItemDO> findAllByIdsOrderByIdStr(List<Long> ids, String idsStr);

    /**
     * 查询所有启用状态的兑换项的id
     */
    public List<Long> findIdAllByEnable(Boolean enable);

    /**
     * 根据name去like查询，如果name为空，那么默认findAll
     */
    public List<ItemDO> findAllByName(String name);

    /**
     * 根据类型查询一个，一般用于直冲类
     */
    public ItemDO findByType(String type);

    /**
     * 查询过期产品（7天 < valid_end_date < new Date）
     */
    public List<ItemDO> findOverdueItem(String type);

    /**
     * 插入
     */
    public ItemDO insert(ItemDO item);

    /**
     * 管理员后台表单更新，平时不可使用
     */
    public void update(ItemDO item);

    public List<Long> findAllPreStockItems(int opType);

    /**
     * 根据expressTemplateId查询
     * @param expressTemplateId
     * @return
     */
    public List<ItemDO> findAllByExpressTemplateId(Long expressTemplateId);

    //ItemExtraJsonDAO
    public int setJsonValue(Long id, String key, String value);

    public String getJsonValue(Long id, String key);


    //ItemStatusChangeDAO
    /**
     * 库存减一,销量加一|一般用于实物在下单阶段被调用
     */
    public int reduceRemaining(Long itemId);

    /**
     * 库存加一,销量减一|一般用于实物在下单失败，或者兑换失败阶段被调用
     */
    public int increaseRemaining(Long itemId);

    /**
     * 兑吧实物失败返还库存 兑吧优惠券
     */
    public int turnbackItemRemaining(Long itemId);

    /**
     * 兑吧券减去库存
     */
    public int decreaseItemRemaining(Long itemId);

    /**
     * 兑吧实物失败扣除销量
     */
    public int turnbackItemSales(Long itemId);

    /**
     * 刷新库存
     */
    public void refreshRemaining(Long id, Date validEndDate, Integer remaining);

    /**
     * 启用或者禁用
     */
    public void enableOrDisableById(Long id, Boolean enable, Boolean deleted);

    /**
     * 设置删除状态
     */
    public void setDelete(Long id, Boolean deleted);

    /**
     * 启用兑换项
     */
    public void enableById(Long id, Boolean enable, Date publishTime);

    /**
     * 更新库存
     */
    public void updateRemaingById(Long id, Integer remaining);

    /**
     * 根据Id修改BatchId
     */
    public void updateBatchIdById(Long id, Long batchId);

    /**
     * 切换批次
     */
    public void switchBatch(Long id, Long batchId, Integer remaining);

    /**
     * 减少库存
     */
    public int subRemainingById(Long id, Integer subRemaining);

    /**
     * 增加库存
     */
    public int addRemainingById(Long id, Integer addRemaining);


    //ItemTextChangeDAO

    public int updateAutoOffDateNull(Long id);

    /**
     * 把限制次数置为空
     */
    public int updateLimitCountNull(Long id);

    /**
     * 把分类ID置为空
     */
    public int updateItemClassifyIdNullByItemClassifyId(Long itemClassifyId);

    /**
     * 把分类ID置为空
     */
    public int updateItemClassifyIdNullById(Long id);

    /**
     * 根据id更新subType
     */
    public void updateSubTypeById(Long id, Integer subType);

    /**
     * 根据id
     */
    public void updateValidEndDateById(Long id, Date validEndDate);

    /**
     * 根据Id修改OperationsType
     */
    public void updateOperationsTypeById(Long id, Integer operationsType);

    /**
     * 更新自动推荐按钮
     */
    public int updateAutoRecommendById(Long id, Boolean autoRecommend);

    /**
     * 更新payload
     */
    public void updatePayloadById(Long id, Integer payload);

    /**
     * 更新库存和时间
     */
    public int updateRemainingAndvalidEndDate(Long id, Integer remaining, Date validEndDate);


    /**
     * 在添加兑吧单品抽奖的时候，添加一个假的item
     */
    public void addFakeItemForDuibaSingleLottery(DuibaSingleLotteryDto duibaSingleLottery);

    public void updateFakeItemForDuibaSingleLottery(DuibaSingleLotteryDto duibaSingleLottery, Long itemId);

    public int offAndExpiredAppItem(Long itemId);

    /**
     * 获取新添加到兑吧产品库的商品数量
     */
    public Integer getNewItemsNum(Long id);

    /**
     * @Title: delete
     * @Description: 删除兑换项
     * @param id
     */
    public Boolean delete(Long id);

    //from ItemService in manager
    /**
     * 修改状态
     */
    public Map<String, Object> changeStatus(Long itemId, Boolean enable);

    //方法名冲突,所以加入_manager后缀,比迁移前的多了个operateId参数
    public ItemDO insert_manager(ItemDO itemDO, Long operateId);

    //方法名冲突,所以加入_manager后缀,比迁移前的多了个operateId参数
    public void update_manager(ItemDO itemDO, Long operateId);

    /**
     *  from ItemCtrl.doUpdateObject in manager
     * @param itemDO
     * @param preRemaining
     * @param remaining
     * @param name4Admin
     * @param limitCount
     * @throws BusinessException
     */
    public void doUpdateObject(ItemDO itemDO, Integer preRemaining, Integer remaining, String name4Admin, String limitCount, Long operateId) throws BusinessException;

    /**
     * from ItemCtrl.doUpdateCoupon,迁移前没有事务
     * @param id
     * @param itemDO
     * @param operateId
     * @param name4Admin
     * @param usePrompt
     * @param btnText
     * @param limitCount
     */
    public ItemDO doUpdateCoupon(String id, ItemDO itemDO, Long operateId, String name4Admin, String usePrompt, String btnText, String limitCount);

    /***
     * Description：兑换项库存列表查询
     * Author：zhengjy
     * Create Time：2016年4月25日 下午4:04:58
     * @return
     */
    public List<ExchangeStockWarnVO> findExchangeStockWarnList(
            Map<String, Object> queryMap);

    /***
     * Description：兑换项库存count
     * Author：zhengjy
     * Create Time：2016年4月26日 下午9:04:58
     * @return
     */
    public Integer findExchangeStockWarnCount(Map<String, Object> queryMap);
    /**
     * Description：查询兑换项库存预警列表
     * Author：zhengjy
     * Create Time：2016年4月26日 下午9:04:58
     * @param queryMap
     * @return
     */
    public List<ExchangeStockWarnVO> findItemStockWarns(
            Map<String, Object> queryMap);

    /**
     * Description：清空兑换项库存表
     * Author：zhengjy
     * Create Time：2016年4月26日 下午9:04:58
     */
    public void emptyExchangeStockWarn();
    /**
     * Description：插入兑换项库存表
     * Author：zhengjy
     * Create Time：2016年4月26日 下午9:04:58
     */
    public void saveExchangeStockWarn(ExchangeStockWarnVO exchangeStockWarnVO);

    /***
     * Description：库存邮箱预警列表
     * Author：zhengjy
     * Create Time：2016年4月26日 下午4:04:58
     * @return
     * @throws Exception
     */
    public List<StockWarnEmailVO> findEmailStockList(
            Map<String, Object> queryMap);
    /***
     * Description：库存邮箱预警保存
     * Author：zhengjy
     * Create Time：2016年4月26日 下午4:04:58
     */
    public void saveEmailStockWarn(String emailStr);

    /***
     * Description：库存邮箱预警清空
     * Author：zhengjy
     * Create Time：2016年4月26日 下午4:04:58
     */
    public void emptyEmailStockWarn();

    /**
     * 查询立即使用按钮
     */
    public int findImmediatelyButtonById(Long id);
}
