package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.domain.dataobject.AppShowcaseContentDO;
import cn.com.duiba.service.domain.vo.ShowcasePreviewVO;
import cn.com.duiba.service.exception.BusinessException;

import java.util.Date;
import java.util.List;
import java.util.Map;

public interface RemoteAppShowcaseContentBackendService {

	//manager

	public void insert(AppShowcaseContentDO appShowcaseContent);

	/**
	 * 查询所有APP中推送的橱窗任务
	 */
	public List<AppShowcaseContentDO> findByDuibaShowcaseTaskId(Long duibaShowcaseTaskId);

	/**
	 * 删除操作
	 */
	public void updateDeletedById(Long id);

	//developer

	/**
	 * 根据ID查询
	 */
	public AppShowcaseContentDO find(Long id);

	/**
	 * 开发者后台编辑更新
	 */
	public void update4DevEdit(AppShowcaseContentDO appShowcaseContent);

    /**
     * 定期清除橱窗内容
     */
    public void clearShowcase();

    /**
     * 获取警告文案
     */
    public String getWarningInfo(Long appId);

    /**
     * 展示在橱窗的商品队列请求+第一个预览
     */
    public Map<String, Object> getShowcases4Dev(Long appId, int place);

    /**
     * 获取预览内容
     */
    public ShowcasePreviewVO getPreviewVO(Long appShowcaseContentId);

    /**
     * 删除
     *
     * @throws Exception
     */
    public void deleteAppShowcaseContent(Long id) throws BusinessException;

}
