package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.activity.center.api.dto.duibaactivity.DuibaActivityDto;

import java.util.List;

public interface RemoteDuibaActivityService {


	/**
	 * 后台关闭并且下架专题活动
	 */
	public DuibaActivityDto closeAndUnViewDuibaActivity(Long id);

	/**
	 * 添加活动到开发者运营活动,这个方法手机端在用
	 */
	public Long addDuibaActivityToDeveloper(Long appId, Long duibaActivityId, String isPreview) throws BusinessException;

	/**
	 * 添加活动到开发者运营活动,这个方法manager端在用
	 */
	public Long addDuibaActivityToDeveloper_manager(Long appId, Long duibaActivityId, String isPreview) throws BusinessException;

	/**
	 * 添加活动到开发者运营活动,这个方法developer端在用
	 */
	public Long addDuibaActivityToDeveloper_developer(Long appId, Long duibaActivityId, String isPreview) throws BusinessException;

	/**
	 * 获取最小积分
	 */
	public Long getDuibaActivityCredits(List<Long> itemIds, Long appId);

	/**
	 * 把所有item推送到app入口
	 */
	public void doMainPushAppItem(Long aid, ItemDO item);

	/**
	 * 把所有item更新推送到app入口
	 */
	public void doUpdateMainPushAppItem(Long appItemId, ItemDO item);

	/**
	 * 添加定向分配到定向表
	 * @param id
	 * @param appIds
	 */
	public void addDuibaActivityAppSpecify(Long id, String[] appIds);

	/**
	 * 后台创建兑吧专题活动-创建权限
	 */
	public void createDuibaActivity(DuibaActivityDto duibaActivity);

	/**
	 * 后台更新兑吧专题活动-更新权限
	 */
	public void updateDuibaActivity(DuibaActivityDto duibaActivity);

	/**
	 * 后台开启专题活动
	 */
	public void startupDuibaActivity(Long id);

	/**
	 * 后台关闭专题活动
	 */
	public DuibaActivityDto closeDuibaActivityNoTransaction(Long id);

	/**
	 * 后台删除专题活动
	 */
	public DuibaActivityDto deleteDuibaActivity(Long id);
	
}
