package cn.com.duiba.service.remoteservice;
import java.util.Date;
import java.util.List;

import cn.com.duiba.service.domain.dataobject.OrdersDO;
import cn.com.duiba.service.domain.vo.ActivityOrdersVO;
import cn.com.duiba.service.domain.vo.ItemAppStatVO;

public interface RemoteMasterOrdersMirrorBussinessService {

	public Integer findOrderCountByAppIdAndDate(Long appId, Date startDate, Date endDate);
	
	/**
	 * 我的订单，根据创建时间查询
	 * @param pageInfo
	 * @return
	 */
	public List<OrdersDO> findOrdersByGmtCreate(Long appId, Date startDate, Date endDate, String itemType, String bizParams, Long consumerId, String orderId, String namelike, String exchangeStatus,Integer offset, Integer max);
	
	public Long countOrdersByGmtCreate(Long appId, Date startDate, Date endDate, String itemType, String bizParams, Long consumerId, String orderId, String namelike, String exchangeStatus);
	
	public Long countOrdersByFinishTime(Long appId, Date startDate, Date endDate, String itemType, String bizParams, Long consumerId, String orderId, String namelike, String exchangeStatus);
	/**
	 * 我的订单，根据结束时间查询
	 * @param pageInfo
	 * @return
	 */
	public List<OrdersDO> findOrdersByFinishTime(Long appId, Date startDate, Date endDate, String itemType, String bizParams, Long consumerId, String orderId, String namelike, String exchangeStatus,Integer offset, Integer max);
	
	public List<OrdersDO> findOrdersByInfo(Long appId,String orderTimeType, Date startDate, Date endDate, String itemType, String bizParams, Long consumerId, String exchangeStatus,Integer offset, Integer max);
	
	public Long countOrderByInfo(Long appId,String orderTimeType, Date startDate, Date endDate, String itemType, String bizParams, Long consumerId, String exchangeStatus);
	
	public List<ActivityOrdersVO> findActivityOrdersPage(Long appId,Long relationId,Integer relationType, Integer offset, Integer max);
	
	public Long findActivityOrdersPageCount(Long appId,Long relationId,Integer relationType);
	
	public List<ItemAppStatVO> findActivityItemApp(Long appId,Long relationId,Integer relationType);
	
	public OrdersDO findByAppAndDeveloperBizId(Long appId,String developerBizId);
	
	public Integer countAppItemNum(Long appId,Long appItemId,Date startTime);
	
	public List<OrdersDO> findAllByIdsAndIdsStr(Long appId,List<Long> ids, String idsStr);
}
