package cn.com.duiba.service.domain.dataobject;

import cn.com.duiba.service.domain.BaseDO;

import java.util.Date;


/**
 * 兑吧推荐位
 */
public class DuibaRecommendQueueDO extends BaseDO {
	private static final long serialVersionUID = -5409996367390870365L;


	public static final Integer TYPE_COUPON = 1; // 优惠券
	public static final Integer TYPE_OBJECT = 2; // 实物
	public static final Integer TYPE_DUIBA_TURNTABLE = 3; // 兑吧大转盘
	public static final Integer TYPE_DUIBA_SINGLE_LOTTERY = 4; // 兑吧单品抽奖
	public static final Integer TYPE_DUIBA_ACTIVITY = 5; // 专题活动
	public static final Integer TYPE_DUIBA_SHAKE = 6;//摇一摇
	public static final Integer TYPE_DUIBA_SCRATCH = 7;//刮刮乐
	public static final Integer TYPE_DUIBA_TIGER = 8;//老虎机
	public static final Integer TYPE_SECKILL = 9;//周三必抢
	public static final Integer TYPE_GAME_SANTA = 10;// 打劫圣诞老人
	public static final Integer TYPE_GAME_YEAR_AWARD = 11;// 数年终奖
	public static final Integer TYPE_GAME_GIRL = 12;//女神PK女汉子游戏
	public static final Integer TYPE_QUESTION_ANSWER = 13;//答题
	public static final Integer TYPE_QUIZZ = 14;//测试题
	public static final Integer TYPE_NGAME = 17;//新游戏
	public static final Integer TYPE_GOOD_LUCK_TURNTABLE = 16;//幸运转盘
	public static final Integer TYPE_GAME_JIONG = 15;//人在囧途
	public static final Integer TYPE_GUESS = 18;//竞猜
	
	public static final String TYPE_COUPON_STRING = "coupon"; // 优惠券
	public static final String TYPE_OBJECT_STRING = "object"; // 实物
	public static final String TYPE_DUIBA_TURNTABLE_STRING = "duibaTurntable"; // 兑吧大转盘
	public static final String TYPE_DUIBA_SINGLE_LOTTERY_STRING = "duibaSingleLottery"; // 兑吧单品抽奖
	public static final String TYPE_DUIBA_ACTIVITY_STRING = "duibaActivity"; // 专题活动
	public static final String TYPE_DUIBA_SHAKE_STRING = "duibaShake";//摇一摇
	public static final String TYPE_DUIBA_SCRATCH_STRING = "duibaScratch";//刮刮乐
	public static final String TYPE_DUIBA_TIGER_STRING = "duibaTiger";//老虎机
	
	public static final Integer TYPE_SANTA = 1;// 打劫圣诞老人
	public static final Integer TYPE_YEAR_AWARD = 2;// 数年终奖
	public static final Integer TYPE_GIRL = 3;//女神PK女汉子游戏
	public static final Integer TYPE_JIONG = 4;
	
	public static final Integer TYPE_SHAKE = 1;//摇一摇抽奖
	public static final Integer TYPE_SCRATCH = 2;//刮刮乐
	public static final Integer TYPE_TURNTABLE = 3;//大转盘
	public static final Integer TYPE_TIGER = 4;//老虎机


	private Long id;

	private String title;

	private Long relationId;

	private Integer relationType;

	private Integer sort;

	private Date gmtCreate;

	private Date gmtModified;

	public DuibaRecommendQueueDO() {
	}

	public DuibaRecommendQueueDO(Long id) {
		this.id = id;
		this.gmtModified = new Date();
		toBeUpdate = true;
	}

	public DuibaRecommendQueueDO(boolean init4insert) {
		if (init4insert) {
			toBeInsert = true;
			gmtCreate = new Date();
			gmtModified = gmtCreate;
		}
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}


	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Long getRelationId() {
		return relationId;
	}

	public void setRelationId(Long relationId) {
		this.relationId = relationId;
	}

	public Integer getRelationType() {
		return relationType;
	}

	public void setRelationType(Integer relationType) {
		this.relationType = relationType;
	}

	public Integer getSort() {
		return sort;
	}

	public void setSort(Integer sort) {
		this.sort = sort;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public static int typeToInt(String type) {
		if (TYPE_COUPON_STRING.equals(type)) {
			return TYPE_COUPON;
		} else if (TYPE_OBJECT_STRING.equals(type)) {
			return TYPE_OBJECT;
		} else if (TYPE_DUIBA_TURNTABLE_STRING.equals(type)) {
			return TYPE_DUIBA_TURNTABLE;
		} else if (TYPE_DUIBA_SINGLE_LOTTERY_STRING.equals(type)) {
			return TYPE_DUIBA_SINGLE_LOTTERY;
		} else if (TYPE_DUIBA_ACTIVITY_STRING.equals(type)) {
			return TYPE_DUIBA_ACTIVITY;
		} else if (TYPE_DUIBA_SHAKE_STRING.equals(type)) {
			return TYPE_DUIBA_SHAKE;
		} else if (TYPE_DUIBA_SCRATCH_STRING.equals(type)) {
			return TYPE_DUIBA_SCRATCH;
		} else if (TYPE_DUIBA_TIGER_STRING.equals(type)) {
			return TYPE_DUIBA_TIGER;
		}
		return -1;
	}
	
	
	public static int typeToHdtoolType(Integer type) {
		if (TYPE_SHAKE.equals(type)) {
			return TYPE_DUIBA_SHAKE;
		} else if (TYPE_TIGER.equals(type)) {
			return TYPE_DUIBA_TIGER;
		} else if (TYPE_SCRATCH.equals(type)) {
			return TYPE_DUIBA_SCRATCH;
		//<!-- added zhengjy 20160414 幸运转盘改为活动工具 begin -->	
		} else if (TYPE_TURNTABLE.equals(type)) {
			return TYPE_GOOD_LUCK_TURNTABLE;
		}  
		//<!-- added zhengjy 20160414 幸运转盘改为活动工具 end -->
		return -1;
	}
	
	public static int typeToGameType(Integer type) {
		if (TYPE_SANTA.equals(type)) {
			return TYPE_GAME_SANTA;
		} else if (TYPE_YEAR_AWARD.equals(type)) {
			return TYPE_GAME_YEAR_AWARD;
		} else if (TYPE_GIRL.equals(type)) {
			return TYPE_GAME_GIRL;
		} else if (TYPE_JIONG.equals(type)) {
			return TYPE_GAME_JIONG;
		} 
		return -1;
	}
	
	@Override
	public String toString() {
		return "DuibaRecommendQueueDO [id=" + id + "]";
	}
}
