package cn.com.duiba.service.domain.dataobject;

import cn.com.duiba.service.domain.BaseDO;

import java.util.Date;
import java.util.HashMap;

public class ItemDO extends BaseDO {
	private static final long serialVersionUID = 43215212321L;
	public static final String Key_Ganji = "ganji";//控制是否显示马上使用按钮的开关，原来就赶集一个应用定制了这个功能，所以命名有些那个。。

	public static final String TypePhonebill = "phonebill";
	public static final String TypeQB = "qb";
	public static final String TypeCoupon = "coupon";
	public static final String TypeAlipayCode = "alipaycode";
	public static final String TypeAlipayFast = "alipayfast";
	public static final String TypeAlipay = "alipay";
	public static final String TypeObject = "object"; // 实物兑换
	/**added zhengjy 20160412  兑换奖项加福袋类型 begin*/
	public static final String LuckyBag = "lucky"; // 福袋
	public static final String LuckyBagTxt = "福袋"; // 福袋
	/**added zhengjy 20160412  兑换奖项加福袋类型 end*/
	public static final String TypeGameCard = "gamecard";
	public static final String TypePhoneflow = "phoneflow";
	public static final String TypeTurntable = "turntable"; // 大转盘
	public static final String TypeSingleLottery = "singleLottery"; //单品抽奖
	public static final String TypeManualLottery = "manualLottery"; //手动开奖
	public static final String TypeHdtollLottery = "hdtoolLottery"; //活动工具
	public static final String TypeGameLottery = "gameLottery";
	public static final String TypeQuestionLottery = "questionLottery";//答题
	public static final String TypeQuizzLottery = "quizzLottery";//测试题
	public static final String TypeNgameLottery = "ngameLottery";//新游戏
	public static final String TypeGuessLottery = "guessLottery";//新游戏
	public static final String TypeFake = "fake"; //伪造类型 兑换项
	public static final String TypeVirtual = "virtual";	//虚拟商品（仅限appItemDO使用）
	public static final String TypePhonebillDingzhi = "phonebillDingzhi";	// 定制的单档位话费类型

	public static final String TypeListFree = "free";	// 免费类（实物和优惠券）
	public static final String TypeListCharge = "charge";	// 收费类（实物和优惠券）

	public static final int TypeIntPhonebill = 1;
	public static final int TypeIntQB = 2;
	public static final int TypeIntPhoneflow = 3;
	public static final int TypeIntCoupon = 4;
	public static final int TypeIntAlipayCode = 5;
	public static final int TypeIntAlipayFast = 6;
	public static final int TypeIntAlipay = 7;
	public static final int TypeIntObject = 8; // 实物兑换
	public static final int TypeIntGameCard = 9;
	public static final int TypeIntTurntable = 10;

	public static final String LimitTypeForever = "forever";  //永久
	public static final String LimitTypeEveryday = "everyday"; //每天
	public static final String LimitTypeBatch = "batch"; //批次
	public static final String LimitTypeMonth = "month"; //每月

	public static final int SubTypeCommon = 0;// 普通优惠券
	public static final int SubTypeLink = 1;// 链接类型优惠券
	public static final int SubTypeRepeat = 2;// 可重复优惠券
	
	public static final int OpTypeTimeLimit=0;	//限时商品
	public static final int OpTypeQuantityLimit=1;	//限量商品
	public static final int OpTypeActivity=2;	//活动专用商品
	public static final int OpTypeSpecify=3;	//定向商品
	public static final int OpTypeDevAudit=4;    //待审核
	public static final int OpTypeDevBlacklist=5;    //黑名单商品
	public static final int OpTypeIndexHidden=6; //涉及商品在已添加到图标或Banner图区后，是否需要在首页兑换区隐藏
	public static final int OpTypeAndriodAlert=7;//兑吧优惠券是否在安卓环境下，点立即领取时，开启出现弹窗提示
	public static final int OpTypeTimeLimitSwitch=8;  //已抢光
	public static final int OpTypeAddrLimit = 9;// 判断是否开启了地域限制
	public static final int OpTypePreStockSwith = 10;//判断兑吧商品是否开启库存预分配功能
	
    public static final int OpTypeIsAmb = 11;//判断商品是否是加钱购商品
    public static final int OpTypeCredits = 12;//开发者端市场价值，是否是积分，默认是积分
    public static final int OpTypeNeedUserName = 13;//虚拟商品在兑换时是否需要输入账号

	
	public static final int SourceTypeNormal = 0; // 普通兑换
	public static final int SourceTypeSingleLottery = 1;//单品抽奖活动
	public static final int SourceTypeKillActivity = 2;//秒杀活动

	//链接类型优惠券 按钮往哪跳
	public static final int LinkToBussiness = 0;//商家落地页
	public static final int LinkToDetail = 1;//兑换详情页
	
	public static final String ExpressTypeFree="free";
	public static final String ExpressTypeUnity="unity";
	public static final String ExpressTypeTemplate="template";

	public ItemDO() {
	}

	public ItemDO(Long id) {
		this.id = id;
		this.gmtModified = new Date();
		toBeUpdate = true;
	}

	public ItemDO(boolean init4insert) {
		if (init4insert) {
			toBeInsert = true;
			facePrice = 0;
			marketPrice = 0;
			actualPrice = 0;
			minCredits = 0L;
			minFacePrice = 0;
			enable = false;
			remaining = 0;
			sales = 0;
			payload = 0;
			duibaType = 0;
			autoRecommend = false;
			deleted = false;
			sourceType = SourceTypeNormal;
			shutDown = false;
			operationsType = 0;
			limitScope = ItemDO.LimitTypeForever;
			gmtCreate = new Date();
			gmtModified = gmtCreate;
		}
	}
	
	private Long id;
	private String tag;
	private String name;
	private String subtitle; // 副标题
	private String logo;
	private String image;
	private String multiImage; // 详情多图展示
	private Integer facePrice;//默认兑换价等值积分(根据汇率兑换为实际积分)
	private Integer marketPrice;//市场价
	private Integer actualPrice;
	private Long minCredits;// 最小兑换积分(此字段已经弃用)
	private Integer minFacePrice;
	private String description;
    private Boolean suggestDownload;//强调下载
    private	String iosOpen; //iOS打开应用连接
	private String iosDownload;
	private String androidDownload;
	private Boolean enable; // 启用停用
	private Integer remaining; // 剩余票数
	private Integer sales; // 销量
	private Integer payload; // 管理员排序 目前自动推荐功能在用
	private String customPrice; // 用户自定义商品价格（可分为1-6栏显示，存储结构为json形式的字符串，
								// 面值1:积分1,面值2:积分2...）
	private String smallImage; // 布局2使用的小图
	private String whiteImage;//白底缩略图
	private Integer limitCount; // 兑换次数限制
	private String limitScope; // 兑换限制作用域：永久/每天

	private String type; // 商品类型，比如 QB，话费充值 等等
	private Integer typeInt;

	private String exchangeTipTemplate; // 兑换提示模板 实物用于 兑换成功文案

	private Long ownerAppId; // App专属商品

	private Long batchId; // 优惠券批次
	
	private Long itemClassifyId; // 优惠券批次

	private Date validStartDate;// 有效期开始时间
	private Date validEndDate; // 有效期结束时间 实物用于下架时间

	private Date publishTime;// 启用时间
	private Boolean deleted;// 是否已经删除
	private String productPrice; // 商品费率

	private Boolean shutDown;// 暂不可用 直充类使用
										// 开启后前台界面的按钮将展示为“暂不可用”，充值系统故障时打开
	private Boolean showAlert; // 是否展示警示区
	private String alertMessage;// 警示文案 实物用于发货后文案
	private Integer duibaType; // 兑吧特殊类型 0表示普通兑吧商品，其它数值为各活动专用的商品，对开发者不可见。
	private Boolean autoRecommend;// 自动推荐标示，目前只支持免费的兑换项 ：优惠券 实物 停用的兑换项
											// 不能开启自动推荐

	private Integer subType; // 优惠券类型，目前只给优惠券使用 0-普通类型 1-链接类型 2--可重复类型
	private String bannerImage;// banner图片
	private Date gmtCreate;
	private Date gmtModified;
	
	private Integer operationsType;	//商品类型  移位运算 第0位：限时商品	第1位：限量商品  第2位：是否运营商品  
	private String	limitTimeBetween;		//每日限时区间
	private Integer limitEverydayQuantity;		//每日限制销量
	private String  limitDate; //兑换日期限制
	
	private Integer sourceType; // 来源类型，目前有 普通兑换类型，单品抽奖类型
	private Long sourceRelationId;
	
	private Date autoOffDate; //定时自动下架日期
	
	private String name4Admin;
	private String usePrompt;
	private String btnText;
	
	private Long	salePrice	;//	兑换价格					
	private String 	expressType	;//	运费类型		free包邮，unify统一运费，template运费模板			
	private Long 	expressPrice	;//	运费价格					
	private Long 	expressTemplateId	;//运费模板ID

	/*** added zhengjy 20160425 兑换项库存预警 begin*/
	private Integer stockWarnValue;//库存预警值
	private Long sellerId;//商家ID
	private String sellerName;//商家名称
	/*** added zhengjy 20160425 兑换项库存预警 end*/

	//Start guoeryang,马上使用按钮的优化 ,2016/05/26
	private Integer immediatelyButton;//弹层中按钮往那条
	//End guoeryang,马上使用按钮的优化 ,2016/05/26
	
	public void setExInfo(String key,String value,String form){
		
	}
	/**
	 * 判断Item是否是档位类型
	 * @param type
	 * @return
	 */
	public boolean isDegree(){
		if(type.equals(TypePhonebill)){
			return true;
		}else if(type.equals(TypeQB)){
			return true;
		}else if(type.equals(TypeAlipay)){
			return true;
		}else if(type.equals(TypeAlipayFast)){
			return true;
		}else if(type.equals(TypeAlipayCode)){
			return true;
		}
		return false;
	}
	
	/**
	 * 无库存类型产品
	 * @return
	 */
	public boolean isNoStock(){
		if(type.equals(TypePhonebill)){
			return true;
		}else if(type.equals(TypePhoneflow)){
			return true;
		}else if(type.equals(TypeQB)){
			return true;
		}else if(type.equals(TypeAlipay)){
			return true;
		}else if(type.equals(TypeAlipayFast)){
			return true;
		}else if(type.equals(TypeAlipayCode)){
			return true;
		}else if(type.equals(TypePhonebillDingzhi)) {
			return true;
		}
		return false;
	}

	public String getSellerName() {
		return sellerName;
	}

	public void setSellerName(String sellerName) {
		this.sellerName = sellerName;
	}

	public Long getSellerId() {
		return sellerId;
	}

	public void setSellerId(Long sellerId) {
		this.sellerId = sellerId;
	}

	public Integer getStockWarnValue() {
		return stockWarnValue;
	}

	public void setStockWarnValue(Integer stockWarnValue){
			this.stockWarnValue = stockWarnValue;
	}

	public void grantOpTypeItem(int opType){
		int v=1<<opType;
		operationsType=operationsType | v;
	}
	
	public void ungrantOpTypeItem(int opType){
		int v=1<<opType;
		v=~v;
		operationsType=operationsType & v;
	}
	
	public boolean isOpTypeItem(int opType){
		int v=1<<opType;
		int ret= operationsType & v;
		return ret!=0;
	}
	
	public Long getItemClassifyId() {
		return itemClassifyId;
	}

	public void setItemClassifyId(Long itemClassifyId) {
		this.itemClassifyId = itemClassifyId;
	}

	public Integer getSourceType() {
		return sourceType;
	}

	public void setSourceType(Integer sourceType) {
		this.sourceType = sourceType;
	}

	public Long getSourceRelationId() {
		return sourceRelationId;
	}

	public void setSourceRelationId(Long sourceRelationId) {
		this.sourceRelationId = sourceRelationId;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getTag() {
		return tag;
	}

	public void setTag(String tag) {
		this.tag = tag;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getSubtitle() {
		return subtitle;
	}

	public void setSubtitle(String subtitle) {
		this.subtitle = subtitle;
	}
	
	public Long getMinCredits() {
		return minCredits;
	}

	public void setMinCredits(Long minCredits) {
		this.minCredits = minCredits;
	}

	public String getLogo() {
		return logo;
	}

	public void setLogo(String logo) {
		this.logo = logo;
	}

	public String getImage() {
		return image;
	}

	public void setImage(String image) {
		this.image = image;
	}

	public String getMultiImage() {
		return multiImage;
	}

	public void setMultiImage(String multiImage) {
		this.multiImage = multiImage;
	}

	public Integer getFacePrice() {
		return facePrice;
	}

	public void setFacePrice(Integer facePrice) {
		this.facePrice = facePrice;
	}

	public Integer getMarketPrice() {
		return marketPrice;
	}

	public void setMarketPrice(Integer marketPrice) {
		this.marketPrice = marketPrice;
	}

	public Integer getActualPrice() {
		return actualPrice;
	}

	public void setActualPrice(Integer actualPrice) {
		this.actualPrice = actualPrice;
	}

	public Integer getMinFacePrice() {
		return minFacePrice;
	}

	public void setMinFacePrice(Integer minFacePrice) {
		this.minFacePrice = minFacePrice;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getIosDownload() {
		return iosDownload;
	}

	public void setIosDownload(String iosDownload) {
		this.iosDownload = iosDownload;
	}

	public String getAndroidDownload() {
		return androidDownload;
	}

	public void setAndroidDownload(String androidDownload) {
		this.androidDownload = androidDownload;
	}

	public Boolean getEnable() {
		return enable;
	}

	public void setEnable(Boolean enable) {
		this.enable = enable;
	}

	public Integer getRemaining() {
		return remaining;
	}

	public void setRemaining(Integer remaining) {
		this.remaining = remaining;
	}

	public Integer getSales() {
		return sales;
	}

	public void setSales(Integer sales) {
		this.sales = sales;
	}

	public Integer getPayload() {
		return payload;
	}

	public void setPayload(Integer payload) {
		this.payload = payload;
	}

	public String getCustomPrice() {
		return customPrice;
	}

	public void setCustomPrice(String customPrice) {
		this.customPrice = customPrice;
	}

	public String getSmallImage() {
		return smallImage;
	}

	public void setSmallImage(String smallImage) {
		this.smallImage = smallImage;
	}

	public Integer getLimitCount() {
		return limitCount;
	}

	public void setLimitCount(Integer limitCount) {
		this.limitCount = limitCount;
	}

	public String getLimitScope() {
		return limitScope;
	}

	public void setLimitScope(String limitScope) {
		this.limitScope = limitScope;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
		setTypeInt(typeToInt(type));
	}

	public Integer getTypeInt() {
		return typeInt;
	}

	public void setTypeInt(Integer typeInt) {
		this.typeInt = typeInt;
	}

	public String getExchangeTipTemplate() {
		return exchangeTipTemplate;
	}

	public void setExchangeTipTemplate(String exchangeTipTemplate) {
		this.exchangeTipTemplate = exchangeTipTemplate;
	}

	public Long getOwnerAppId() {
		return ownerAppId;
	}

	public void setOwnerAppId(Long ownerAppId) {
		this.ownerAppId = ownerAppId;
	}

	public Long getBatchId() {
		return batchId;
	}

	public void setBatchId(Long batchId) {
		this.batchId = batchId;
	}

	public Date getValidStartDate() {
		return validStartDate;
	}

	public void setValidStartDate(Date validStartDate) {
		this.validStartDate = validStartDate;
	}

	public Date getValidEndDate() {
		return validEndDate;
	}

	public void setValidEndDate(Date validEndDate) {
		this.validEndDate = validEndDate;
	}

	public Date getPublishTime() {
		return publishTime;
	}

	public void setPublishTime(Date publishTime) {
		this.publishTime = publishTime;
	}

	public Boolean getDeleted() {
		return deleted;
	}

	public void setDeleted(Boolean deleted) {
		this.deleted = deleted;
	}

	public String getProductPrice() {
		return productPrice;
	}

	public void setProductPrice(String productPrice) {
		this.productPrice = productPrice;
	}

	public Boolean getShutDown() {
		return shutDown;
	}

	public void setShutDown(Boolean shutDown) {
		this.shutDown = shutDown;
	}

	public Boolean getShowAlert() {
		return showAlert;
	}

	public void setShowAlert(Boolean showAlert) {
		this.showAlert = showAlert;
	}

	public String getAlertMessage() {
		return alertMessage;
	}

	public void setAlertMessage(String alertMessage) {
		this.alertMessage = alertMessage;
	}

	public Integer getDuibaType() {
		return duibaType;
	}

	public void setDuibaType(Integer duibaType) {
		this.duibaType = duibaType;
	}

	public Boolean getAutoRecommend() {
		return autoRecommend;
	}

	public void setAutoRecommend(Boolean autoRecommend) {
		this.autoRecommend = autoRecommend;
	}

	public Integer getSubType() {
		return subType;
	}

	public void setSubType(Integer subType) {
		this.subType = subType;
	}

	public String getBannerImage() {
		return bannerImage;
	}

	public void setBannerImage(String bannerImage) {
		this.bannerImage = bannerImage;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public static int typeToInt(String type) {
		if (TypePhonebill.equals(type)) {
			return TypeIntPhonebill;
		} else if (TypeQB.equals(type)) {
			return TypeIntQB;
		} else if (TypeCoupon.equals(type)) {
			return TypeIntCoupon;
		} else if (TypeAlipayCode.equals(type)) {
			return TypeIntAlipayCode;
		} else if (TypeAlipayFast.equals(type)) {
			return TypeIntAlipayFast;
		} else if (TypeAlipay.equals(type)) {
			return TypeIntAlipay;
		} else if (TypeObject.equals(type)) {
			return TypeIntObject;
		} else if (TypeGameCard.equals(type)) {
			return TypeIntGameCard;
		} else if (TypePhoneflow.equals(type)) {
			return TypeIntPhoneflow;
		} else if (TypeTurntable.equals(type)) {
			return TypeIntTurntable;
		}
		return -1;
	}

	public static String typeToString(int typeInt) {
		if (typeInt == TypeIntPhonebill) {
			return TypePhonebill;
		} else if (typeInt == TypeIntQB) {
			return TypeQB;
		} else if (typeInt == TypeIntCoupon) {
			return TypeCoupon;
		} else if (typeInt == TypeIntAlipayCode) {
			return TypeAlipayCode;
		} else if (typeInt == TypeIntAlipayFast) {
			return TypeAlipayFast;
		} else if (typeInt == TypeIntAlipay) {
			return TypeAlipay;
		} else if (typeInt == TypeIntObject) {
			return TypeObject;
		} else if (typeInt == TypeIntGameCard) {
			return TypeGameCard;
		} else if (typeInt == TypeIntPhoneflow) {
			return TypePhoneflow;
		} else if (typeInt == TypeIntTurntable) {
			return TypeTurntable;
		}
		return null;
	}

	public Integer getOperationsType() {
		return operationsType;
	}

	public void setOperationsType(Integer operationsType) {
		this.operationsType = operationsType;
	}

	public String getLimitTimeBetween() {
		return limitTimeBetween;
	}

	public void setLimitTimeBetween(String limitTimeBetween) {
		this.limitTimeBetween = limitTimeBetween;
	}

	public Integer getLimitEverydayQuantity() {
		return limitEverydayQuantity;
	}

	public void setLimitEverydayQuantity(Integer limitEverydayQuantity) {
		this.limitEverydayQuantity = limitEverydayQuantity;
	}

	public Boolean getSuggestDownload() {
	    return suggestDownload;
    }

	public void setSuggestDownload(Boolean suggestDownload) {
	    this.suggestDownload = suggestDownload;
    }

	public String getIosOpen() {
	    return iosOpen;
    }

	public void setIosOpen(String iosOpen) {
	    this.iosOpen = iosOpen;
    }

	
	public static String utilToName(Integer typeInt){
		String itemName="";
		HashMap <Integer,String> templateIntMap=new HashMap<Integer,String>();
		templateIntMap.put(1, "话费");
		templateIntMap.put(2, "Q币");
		templateIntMap.put(3, "手机流量");
		templateIntMap.put(4, "优惠券");
		templateIntMap.put(5, "支付宝充值码");
		templateIntMap.put(6, "支付宝提现");
		templateIntMap.put(7, "支付宝官方");
		templateIntMap.put(8, "实物");
		templateIntMap.put(9, "点卡充值");
		templateIntMap.put(10, "大转盘");

		if(templateIntMap.containsKey(typeInt)){
			itemName=templateIntMap.get(typeInt);
		}
		return itemName;
	}

	public String getName4Admin() {
		return name4Admin;
	}

	public void setName4Admin(String name4Admin) {
		this.name4Admin = name4Admin;
	}

	public String getLimitDate() {
		return limitDate;
	}

	public void setLimitDate(String limitDate) {
		this.limitDate = limitDate;
	}

	public Date getAutoOffDate() {
		return autoOffDate;
	}

	public void setAutoOffDate(Date autoOffDate) {
		this.autoOffDate = autoOffDate;
	}

	public String getWhiteImage() {
		return whiteImage;
	}

	public void setWhiteImage(String whiteImage) {
		this.whiteImage = whiteImage;
	}

	public Long getSalePrice()
	{
		return salePrice;
	}

	public void setSalePrice(Long salePrice)
	{
		this.salePrice = salePrice;
	}

	public String getExpressType()
	{
		return expressType;
	}

	public void setExpressType(String expressType)
	{
		this.expressType = expressType;
	}

	public Long getExpressPrice()
	{
		return expressPrice;
	}

	public void setExpressPrice(Long expressPrice)
	{
		this.expressPrice = expressPrice;
	}

	public Long getExpressTemplateId()
	{
		return expressTemplateId;
	}

	public void setExpressTemplateId(Long expressTemplateId)
	{
		this.expressTemplateId = expressTemplateId;
	}

	public String getUsePrompt() {
		return usePrompt;
	}

	public void setUsePrompt(String usePrompt) {
		this.usePrompt = usePrompt;
	}

	public String getBtnText() {
		return btnText;
	}

	public void setBtnText(String btnText) {
		this.btnText = btnText;
	}
	public static String getTypeName(String type){
		if(TypeCoupon.equals(type)){
			return "优惠券";
		}else if(TypeObject.equals(type)){
			return "实物类";
		}else if(LuckyBag.equals(type)){
			return "福袋";
		}else if(TypeQB.equals(type)){
			return "QB";
		}
		return "";
	}

	public Integer getImmediatelyButton() {
		return immediatelyButton;
	}

	public void setImmediatelyButton(Integer immediatelyButton) {
		this.immediatelyButton = immediatelyButton;
	}
}
