package cn.com.duiba.service.item.remoteservice;

import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.domain.vo.ItemOpenVO;
import cn.com.duiba.service.item.domain.vo.ItemKeyVO;
import com.google.common.collect.LinkedListMultimap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by wenqi.huang on 16/5/5.
 */
public interface RemoteItemKeyService {
    /**
     * appId 必填
     * itemId 和appItemId 二选一
     * @param itemId
     * @param appItemId
     * @param appId
     * @return
     */
    public ItemKey getItemKey(Long itemId, Long appItemId, final Long appId);

    /**
     * app必填（注意是AppDO类型）
     * itemId和appItemId 二选一。
     * @param itemId
     * @param appItemId
     * @param app
     * @return
     */
    public ItemKey getItemKey(Long itemId, Long appItemId, AppDO app);

    /**
     * 获取ItemKey，包含已经删除的结果
     * @param itemId
     * @param appItemId
     * @param appId
     * @return
     */
    public ItemKey getItemKeyIncludeDeleted(Long itemId, Long appItemId, Long appId);

    /**
     * 获取ItemKey，包含已经删除的结果
     * @param itemId
     * @param appItemId
     * @param appId
     * @return
     */
    public ItemKey getItemKeyIncludeDeleted(Long itemId, Long appItemId, AppDO app);

    /**
     * 根据批量AppItem获取批量ItemKey，带顺序
     * @param appItems
     * @param app
     * @return
     */
    public List<ItemKey> getBatchItemKeyByAppItem(List<AppItemDO> appItems, AppDO app);

    /**
     * 传对象构造ItemKey
     * @author 方雄韬 2014年12月17日
     * @param item
     * @param appItem
     * @param app
     * @return
     */
    public ItemKey getItemKey(ItemDO item, AppItemDO appItem, AppDO app);

    public List<ItemKey> getBatchItemKeyByAppItemIds(List<Long> activityAppItemIds,AppDO app);

    public List<Map<String, Object>> formatItemListTypeInner(List<ItemKey> itemKey, AppDO app, List<ItemOpenVO> openVOs, List<ItemKeyVO> itemKeyVOs, ConsumerDO consumer, String itemType, int imageStyle, boolean isAliyunOrDaily) throws Exception;

    public List<ItemOpenVO> transformOpenVOListInner(List<ItemKeyVO> ikvs, AppDO app, Long consumerId, int imageStyle, boolean isEnvBaiduOrDaily);
}
