package cn.com.duiba.service.domain.dataobject;

import cn.com.duiba.service.domain.BaseDO;
import cn.com.duiba.service.tools.SecureTool;

import java.util.Date;

public class AppDO extends BaseDO {
	private static final long serialVersionUID = 41001L;

	public static final int BoundAlipay = 0; // 支付宝账号绑定
	public static final int BoundQQ = 1; // QB号码绑定
	public static final int BoundPhone = 2; // 手机号码绑定
	public static final int SwitchOpenVipLimit = 3; // 是否开启会员限制
	public static final int SwitchOpenShare = 4;	// 是否开启分享功能
	public static final int SwitchCodeEdit = 5;//是否开启代码编辑
	public static final int SwitchCloseClientAlarm = 6;//是否关闭客户端未使用源码警示
	public static final int SwitchCloseAppTradingLimit = 7;//是否开启APP交易限制
	public static final int SwitchCreditsDecimalPoint  = 8;//是否开启提供人民币格式展示
	public static final int SwitchShowcasePlace1 = 9;	// 橱窗位1
	public static final int SwitchShowcasePlace2 = 10;	// 橱窗位2
	public static final int SwitchShowcasePlace3 = 11;	// 橱窗位3
	public static final int SwitchCloseCreditsType  = 12;//是否开启积分模式
	public static final int SwitchUseLoginCode  = 13;//是否开启定制唤起登录
	public static final int SwitchFreeItemVip = 14;//开启兑吧免费商品设置会员等级
	//Start guoeryang,开发者可编辑兑吧活动的抽奖积分,2016/05/03
	public static final int SwitchExchangeCreditsType = 16;//可编辑抽奖积分
	//End guoeryang,开发者可编辑兑吧活动的抽奖积分,2016/05/03 

	public static final int SwitchOpenBulletin = 15;//开启首页公示条

	private Long id;

	private Long developerId;

	private String name;

	private String title;

	private String appKey;

	private String appSecret;

	private String appSecretCode;

	private String logo;
	@Deprecated//请使用appLayout中的themeColor
	private String color;

	private String category1;

	private String category2;

	private Integer budget;// 月预算

	private Integer budgetRemain;// 当月剩余

	private Integer dayBudget;// 日预算

	private Integer dayBudgetRemain;// 当日剩余

	private Integer auditPricePerConsumer;// 用户单笔免审核上限

	private Integer creditsRate;// 积分兑换金钱的比例 1元对应多少个积分

	private Boolean enable;

	private Boolean sendSecret;// 是否已经发送过secret

	private String unitName; // 自定义积分单位名称（默认为‘积分’）

	private Boolean bannerEnable; // 是否展示Banner

	private Integer layout; // 默认null是1

	private Boolean buttonEnable;// 是否展示Button区

	private Date newItemTime;

	private String creditsRemainQueryUrl;// ;积分余额查询地址

	private String creditsConsumeRequestUrl; // 积分扣除地址

	private String creditsConsumeNotifyUrl; // 积分消耗的结果通知地址

    private String virtualExchangeUrl; //虚拟商品充值接口

	private Integer showItemNum; // 最多展示的兑换项数量 目前分为三档 15 20 25个 默认展示20个

	private Boolean autoRecommend; // 自动推荐 默认开启

	private Integer appSwitch; // 账号绑定 移位运算 第0位：支付宝 第1位：QB 第2位：手机号 第3位：会员限制开关  第4位：分享功能开关 第5位:开启代码编辑 第6位:是否关闭未使用源码警示

	private Date gmtCreate;

	private Date gmtModified;
	// APP会员等级配置
	private String vipLevelConfig;

	private String earnCreditsUrl;//赚取积分链接

	private String recordNotifyUrl;//兑换记录通知链接

	public AppDO(boolean init4insert) {
		if (init4insert) {
			toBeInsert = true;

			showItemNum = 20;
			autoRecommend = true;
			buttonEnable = true;
			bannerEnable = true;
			unitName = "积分";
			sendSecret = false;
			enable = false;
			auditPricePerConsumer = 0;
			appSwitch = 0;

			gmtCreate = new Date();
			gmtModified = new Date();
//			if (appKey == null) {
//				appKey = RandomUtils.getRandomString(16);
//				appSecret = RandomUtils.getRandomString(30);
//			}
			enable = false;
			color = "#11c3bc";
		}
	}

	public AppDO() {
	}

	public AppDO(Long id) {
		this.id = id;
		this.gmtModified = new Date();
		toBeUpdate = true;
	}

	public void checkApiEnableUpdate() {
		gmtModified = new Date();
		if (creditsConsumeRequestUrl == null || creditsConsumeRequestUrl.trim().length() == 0 || creditsConsumeNotifyUrl == null || creditsConsumeNotifyUrl.trim().length() == 0) {
			enable = false;
		} else {
			enable = true;
		}
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public void grantAppSwitch(int boundType) {
		int v = 1 << boundType;
		appSwitch = appSwitch | v;
	}

	public void ungrantAppSwitch(int boundType) {
		int v = 1 << boundType;
		v = ~v;
		appSwitch = appSwitch & v;
	}

	public boolean isAppSwitch(int boundType) {
		int v = 1 << boundType;
		int ret = appSwitch & v;
		return ret != 0;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getDeveloperId() {
		return developerId;
	}

	public void setDeveloperId(Long developerId) {
		this.developerId = developerId;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getAppKey() {
		return appKey;
	}

	public void setAppKey(String appKey) {
		this.appKey = appKey;
	}

	public String getAppSecret() {
		return SecureTool.decryptAppSecretCode(getAppSecretCode());
	}

	public void setAppSecret(String appSecret) {
		setAppSecretCode(SecureTool.encryptAppSecret(appSecret));
	}

	public String getAppSecretCode() {
		return appSecretCode;
	}

	public void setAppSecretCode(String appSecretCode) {
		this.appSecretCode = appSecretCode;
	}

	public String getLogo() {
		return logo;
	}

	public void setLogo(String logo) {
		this.logo = logo;
	}
	@Deprecated
	public String getColor() {
		return color;
	}
	@Deprecated
	public void setColor(String color) {
		this.color = color;
	}

	public String getCategory1() {
		return category1;
	}

	public void setCategory1(String category1) {
		this.category1 = category1;
	}

	public String getCategory2() {
		return category2;
	}

	public void setCategory2(String category2) {
		this.category2 = category2;
	}

	public Integer getBudget() {
		return budget;
	}

	public void setBudget(Integer budget) {
		this.budget = budget;
	}

	public Integer getBudgetRemain() {
		return budgetRemain;
	}

	public void setBudgetRemain(Integer budgetRemain) {
		this.budgetRemain = budgetRemain;
	}

	public Integer getDayBudget() {
		return dayBudget;
	}

	public void setDayBudget(Integer dayBudget) {
		this.dayBudget = dayBudget;
	}

	public Integer getDayBudgetRemain() {
		return dayBudgetRemain;
	}

	public void setDayBudgetRemain(Integer dayBudgetRemain) {
		this.dayBudgetRemain = dayBudgetRemain;
	}

	public Integer getAuditPricePerConsumer() {
		return auditPricePerConsumer;
	}

	public void setAuditPricePerConsumer(Integer auditPricePerConsumer) {
		this.auditPricePerConsumer = auditPricePerConsumer;
	}

	public Integer getCreditsRate() {
		return creditsRate;
	}

	public void setCreditsRate(Integer creditsRate) {
		this.creditsRate = creditsRate;
	}

	public Boolean getEnable() {
		return enable;
	}

	public void setEnable(Boolean enable) {
		this.enable = enable;
	}

	public Boolean getSendSecret() {
		return sendSecret;
	}

	public void setSendSecret(Boolean sendSecret) {
		this.sendSecret = sendSecret;
	}

	public String getUnitName() {
		return unitName;
	}

	public void setUnitName(String unitName) {
		this.unitName = unitName;
	}

	public Boolean getBannerEnable() {
		return bannerEnable;
	}

	public void setBannerEnable(Boolean bannerEnable) {
		this.bannerEnable = bannerEnable;
	}

	public Integer getLayout() {
		return layout;
	}

	public void setLayout(Integer layout) {
		this.layout = layout;
	}

	public Boolean getButtonEnable() {
		return buttonEnable;
	}

	public void setButtonEnable(Boolean buttonEnable) {
		this.buttonEnable = buttonEnable;
	}

	public Date getNewItemTime() {
		return newItemTime;
	}

	public void setNewItemTime(Date newItemTime) {
		this.newItemTime = newItemTime;
	}

	public String getCreditsRemainQueryUrl() {
		return creditsRemainQueryUrl;
	}

	public void setCreditsRemainQueryUrl(String creditsRemainQueryUrl) {
		this.creditsRemainQueryUrl = creditsRemainQueryUrl;
	}

	public String getCreditsConsumeRequestUrl() {
		return creditsConsumeRequestUrl;
	}

	public void setCreditsConsumeRequestUrl(String creditsConsumeRequestUrl) {
		this.creditsConsumeRequestUrl = creditsConsumeRequestUrl;
	}

	public String getCreditsConsumeNotifyUrl() {
		return creditsConsumeNotifyUrl;
	}

	public void setCreditsConsumeNotifyUrl(String creditsConsumeNotifyUrl) {
		this.creditsConsumeNotifyUrl = creditsConsumeNotifyUrl;
	}

	public String getVirtualExchangeUrl() {
		return virtualExchangeUrl;
	}

	public void setVirtualExchangeUrl(String virtualExchangeUrl) {
		this.virtualExchangeUrl = virtualExchangeUrl;
	}

	public Integer getShowItemNum() {
		return showItemNum;
	}

	public void setShowItemNum(Integer showItemNum) {
		this.showItemNum = showItemNum;
	}

	public Boolean getAutoRecommend() {
		return autoRecommend;
	}

	public void setAutoRecommend(Boolean autoRecommend) {
		this.autoRecommend = autoRecommend;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public Integer getAppSwitch() {
		return appSwitch;
	}

	public void setAppSwitch(Integer appSwitch) {
		this.appSwitch = appSwitch;
	}

	@Override
	public int hashCode() {
		return id.hashCode() * 37 + name.hashCode() * 17;
	}

	@Override
	public boolean equals(Object obj) {
		if (obj instanceof AppDO) {
			AppDO app = (AppDO) obj;
			return (app.id.equals(id) && app.name.equals(name));
		}
		return super.equals(obj);
	}

	public String getVipLevelConfig() {
		return vipLevelConfig;
	}

	public void setVipLevelConfig(String vipLevelConfig) {
		this.vipLevelConfig = vipLevelConfig;
	}

	public String getEarnCreditsUrl() {
		return earnCreditsUrl;
	}

	public void setEarnCreditsUrl(String earnCreditsUrl) {
		this.earnCreditsUrl = earnCreditsUrl;
	}

	public String getRecordNotifyUrl() {
		return recordNotifyUrl;
	}

	public void setRecordNotifyUrl(String recordNotifyUrl) {
		this.recordNotifyUrl = recordNotifyUrl;
	}
}
